package com.ats.platforms.dao;

import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;

import com.ats.platforms.domain.User;

/**
 * User Data Access Object (Dao) interface.
 *
 * <p>
 * <a href="UserDao.java.html"><i>View Source</i></a>
 * </p>
 *
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a> 
 * Created: Jan 23, 2007 
 */
public interface UserDao extends GenericJpaDao<User, Long>, UserDetailsService {
    
    /**
     * Gets users information based on login name.
     * @param username the user's username
     * @return userDetails populated userDetails object
     */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException;
    
    public void register(User entity) ;
    
    
}
