/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.dao.impl;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.support.JpaDaoSupport;

import com.ats.platforms.dao.GenericJpaDao;
import com.ats.platforms.domain.Role;

/**
 * @author rmeder
 * Created: Dec 10, 2006
 * 
 *
 */
public abstract class AbstractGenericJpaDao <T, ID extends Serializable>
	extends JpaDaoSupport
	implements GenericJpaDao<T, ID> {
	
	/**
	 * the logging instance for tracing 
	 */
	private static final Log LOG = LogFactory.getLog(AbstractGenericJpaDao.class);

	/**
	 * the entity type 
	 */
	private Class<T> entityType;
	
	/**
	 * 
	 */
	public AbstractGenericJpaDao() {
		super();
		this.entityType = (Class<T>) ((ParameterizedType) getClass()
                .getGenericSuperclass()).getActualTypeArguments()[0];
	}

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#clear(java.lang.Object)
	 */
	public final void clear() {
		getJpaTemplate().getEntityManager().clear();		
	}
	
	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#contains(java.lang.Object)
	 */
	public final boolean contains(Object entity) {
		checkParam(entity, "entity");
		return getJpaTemplate().contains(entity);
	}

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.Dao#find()
	 */
	@SuppressWarnings("unchecked")
	public final List<T> find() {
		String findAllQuery = "FROM " + getEntityType().getName() + " ";
		if(LOG.isDebugEnabled()) {
			LOG.error("QUERY: find all: " + findAllQuery);
		}
		return (List<T>)getJpaTemplate().find(findAllQuery);
	}

	/**
     * Use this inside subclasses as a convenience method.
     *
     * @param criterion
     * @return
     */
//    @SuppressWarnings("unchecked")
//    protected final List<T> findByCriteria(org.hibernate.criterion.Criterion... criterion) {
//        // Using Hibernate, more difficult with EntityManager and EJB-QL
//        org.hibernate.Session session =
//                ((org.hibernate.ejb.HibernateEntityManager)
//                		getJpaTemplate().getEntityManager()).getSession();
//        org.hibernate.Criteria crit
//                = session.createCriteria(getEntityType());
//        for (org.hibernate.criterion.Criterion c : criterion) {
//            crit.add(c);
//        }
//        return crit.list();
//   }

//	/**
//	 * Find Entities with example data of an Entity
//	 * 
//     * @param exampleInstance
//     * @param excludeProperty
//     * @return
//     */
//    @SuppressWarnings("unchecked")
//    public final List<T> findByExample(T exampleInstance, String... excludeProperty) {
//        // Using Hibernate, more difficult with EntityManager and EJB-QL
//        org.hibernate.Criteria crit = 
//        	((org.hibernate.ejb.HibernateEntityManager)
//        			getJpaTemplate().getEntityManager()).getSession()
//                            .createCriteria(getEntityType());
//        org.hibernate.criterion.Example example =
//                org.hibernate.criterion.Example.create(exampleInstance);
//        for (String exclude : excludeProperty) {
//            example.excludeProperty(exclude);
//        }
//        crit.add(example);
//        return crit.list();
//    }

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#findById(java.io.Serializable)
	 */
	public final T find(ID id) {
		checkParam(id, "id");
		return (T)getJpaTemplate().find(getEntityType(), id);
	}
	
	

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.Dao#find(java.lang.Object)
	 */
	public final List find(T entity) {
		checkParam(entity, "entity");
		// TODO implement it via reflection if needed!
		return null;
	}

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#flush(java.lang.Object)
	 */
	public final void flush() {
		
		getJpaTemplate().flush();
	}

	/**
	 * @return the entityType
	 */
	public final Class<T> getEntityType() {
		return this.entityType;
	}
	
	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#merge(java.lang.Object)
	 */
	public final T merge(T entity) {
		checkParam(entity, "entity");
		return getJpaTemplate().merge(entity);
	}

	
	
	
	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#persist(java.lang.Object)
	 */	
	public final void persist(T entity) {
		checkParam(entity, "entity");
		getJpaTemplate().persist(entity);		
	}
    
    /* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#refresh(java.lang.Object)
	 */
	public final void refresh(Object entity) {
		checkParam(entity, "entity");
		getJpaTemplate().getEntityManager().refresh(entity);
	}

	

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.GenericJpaDao#remove(java.lang.Object)
	 */
	public final void remove(T entity) {
		//checkParam(entity, "entity");
		getJpaTemplate().remove(entity);
	}

	/* (non-Javadoc)
	 * @see com.ats.platforms.dao.Dao#remove(java.lang.Object, java.io.Serializable)
	 * List<? extends Shape>
	 */
	public final void remove(Class<? extends Role> clazz, ID id) {
		Object object = getJpaTemplate().find(clazz, id);
		getJpaTemplate().remove(object);
	}

	/**
	 * util method for checking params. A param can't be null 
	 * and if the param is of type <code>String</code> it is not allowed to be a empty <code>String</code>.
	 * 
	 * @param param the param
	 * @param paramName the name of the param
	 * @throws IllegalArgumentException
	 */
	protected final void checkParam(Object param, String paramName) throws IllegalArgumentException {
		if(param == null)
		{
			throw new IllegalArgumentException("'" + paramName + "' can't be null!");
		}
		
		if(param instanceof String)
		{
			if(((String)param).length() == 0)
			{
				throw new IllegalArgumentException("String '" + paramName + "' can't be empty!");
			}
		}		
	}
	

}
