package com.ats.platforms.dao.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.support.JpaDaoSupport;

import com.ats.platforms.dao.LookupDao;
import com.ats.platforms.domain.Ennagram;
import com.ats.platforms.domain.Role;

/**
 * JPA implementation of LookupDao.
 *
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a> 
 * Created: Jan 23, 2007
 * 
 *
 */
public class LookupJpaDao 
	extends JpaDaoSupport 
	implements LookupDao {
	
	/**
	 * the logging instance for tracing 
	 */
	private static final Log LOG = LogFactory.getLog(LookupJpaDao.class);

    /**
     * @see org.appfuse.dao.LookupDao#getRoles()
     */
	@SuppressWarnings(value={"unchecked"})
    public List<Role> getRoles() {
        if(LOG.isDebugEnabled()) {
        	LOG.debug("retrieving all role names...");
        }

        return (List<Role>)getJpaTemplate().find(
                "select r from Role r order by r.authority");
    }

    /* (non-Javadoc)
     * @see com.ats.platforms.dao.LookupDao#getEnnagrams()
     */
    @SuppressWarnings(value={"unchecked"})
    public List<Ennagram> getEnnagrams() {
        if(LOG.isDebugEnabled()) {
            LOG.debug("retrieving all ennagrams ...");
        }

        return (List<Ennagram>)getJpaTemplate().find(
                "select e from Ennagram e order by e.name");
    }

	
}
