package com.ats.platforms.dao.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ats.platforms.dao.EnnagramDao;
import com.ats.platforms.dao.RoleDao;
import com.ats.platforms.dao.UserDao;
import com.ats.platforms.domain.Ennagram;
import com.ats.platforms.domain.Role;
import com.ats.platforms.domain.User;


/**
 * This class interacts with Spring's HibernateTemplate to save/delete and
 * retrieve User objects.
 *
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a> 
 * Created: Jan 23, 2007 
 */
public class UserJpaDao 
	extends AbstractGenericJpaDao<User, Long> 
	implements UserDao {
 
    EnnagramDao ennagramDao = null;
    RoleDao roleDao = null;
    
    
	/**
	 * the logging instance for tracing 
	 */
	private static final Log LOG = LogFactory.getLog(UserJpaDao.class);

    /** 
    * @see org.acegisecurity.userdetails.UserDetailsService#loadUserByUsername(java.lang.String)
    */
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    	if (LOG.isDebugEnabled()) {
    		LOG.debug("try to load user='"+username+"'");			
		}
    	Map<String,String> map = new HashMap<String, String>();
		map.put("userName", username);		
		List result = getJpaTemplate().findByNamedParams(
				"select u from User u where u.username = :userName", map);        
       
        if (result == null || result.isEmpty()) {
            throw new UsernameNotFoundException("" +
            		"user '" + username + "' not found...");
        } else {
            return (UserDetails) result.get(0);
        }
    }
    
    public void register(User entity) {
        super.checkParam(entity, "entity");
        
        Ennagram primaryEnnagram = entity.getPrimaryEnnagram();
        if(primaryEnnagram != null && primaryEnnagram.getId() != 0) {
            Ennagram ennagram = this.ennagramDao.find(primaryEnnagram.getId());
            entity.setPrimaryEnnagram(ennagram);
        } else {
            entity.setPrimaryEnnagram(null);
        }
        
        Ennagram secondaryEnnagram = entity.getSecondaryEnnagram();
        if(secondaryEnnagram != null && secondaryEnnagram.getId() != 0) {
            Ennagram ennagram = this.ennagramDao.find(secondaryEnnagram.getId());
            entity.setSecondaryEnnagram(ennagram);
        } else {
            entity.setSecondaryEnnagram(null);
        }
        
        // Set the default role for the user
        Set<Role> roles = new HashSet<Role>();
        roles.add(this.roleDao.find("user"));
        entity.setRoles(roles);
        
        entity.setEnabled(true);
        
        getJpaTemplate().persist(entity);       
    }

    /**
     * @return the ennagramDao
     */
    public EnnagramDao getEnnagramDao() {
        return this.ennagramDao;
    }

    /**
     * @param ennagramDao the ennagramDao to set
     */
    public void setEnnagramDao(EnnagramDao ennagramDao) {
        this.ennagramDao = ennagramDao;
    }

    /**
     * @param roleDao the roleDao to set
     */
    public void setRoleDao(RoleDao roleDao) {
        this.roleDao = roleDao;
    }

    /**
     * @return the roleDao
     */
    public RoleDao getRoleDao() {
        return this.roleDao;
    }
    
}