/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.dao.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ats.platforms.dao.AbstractJpaDaoTest;
import com.ats.platforms.dao.LookupDao;
import com.ats.platforms.domain.Ennagram;
import com.ats.platforms.domain.Role;

/**
 * The lookup dao is used for loading reference data, e.g. for drop down lists.
 * 
 * @author <a href="mailto:robert.mederer@accenture.com">Robert Mederer</a>
 * Created: Jan 14, 2007
 * 
 *
 */
public class LookupJpaDaoTest extends AbstractJpaDaoTest {

	/**
	 * the logging instance for tracing 
	 */
	private static final Log LOG = LogFactory.getLog(LookupJpaDaoTest.class);
	
	/**
	 * the dao instance for test
	 */
	private LookupDao lookupDao = null;
	
	/**
	 * Test method for {@link com.ats.platforms.dao.impl.LookupJpaDao#getRoles()}.
	 */
	public final void testGetRoles() {
		boolean testConditon = false;
		List<Role> roles = this.lookupDao.getRoles();
		
		assertNotNull("roles could not be null!", roles);
		
		assertTrue("roles count must be 3!",roles.size()==3);
		
		for (Role role : roles) {
			LOG.debug("found role=" + role.toString() );
			if(role.getAuthority().equals("admin")) {
				testConditon = true;
			}
		}
		assertTrue("Expected Role not found!", testConditon);
	}
    
	/**
	 * Test method for {@link com.ats.platforms.dao.impl.LookupJpaDao#getEnnagrams()}.
	 */
	public final void testGetEnnagrams() {
	    boolean testConditon = false;
	    List<Ennagram> ennagrams = this.lookupDao.getEnnagrams();
	    
	    assertNotNull("ennagrams could not be null!", ennagrams);
	    
	    //assertTrue("ennagrams count must be 3!",ennagrams.size()==3);
	    
	    for (Ennagram en : ennagrams) {
	        LOG.debug("found ennagram=" + en.toString());
	        if(en.getName().equals("LEADER")) {
	            testConditon = true;
	        }
	    }
	    assertTrue("Expected Ennagram not found!", testConditon);
	}

	/**
	 * @return the lookupDao
	 */
	public LookupDao getLookupDao() {
		return this.lookupDao;
	}

	/**
	 * @param lookupDao the lookupDao to set
	 */
	public void setLookupDao(LookupDao lookupDao) {
		this.lookupDao = lookupDao;
	}

}
