/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.dao.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ats.platforms.dao.AbstractJpaDaoTest;
import com.ats.platforms.dao.LookupDao;
import com.ats.platforms.dao.RcdStatusDao;
import com.ats.platforms.dao.RoleDao;
import com.ats.platforms.dao.TttResultDao;
import com.ats.platforms.dao.UserDao;
import com.ats.platforms.domain.Address;
import com.ats.platforms.domain.Ennagram;
import com.ats.platforms.domain.RcdStatus;
import com.ats.platforms.domain.Role;
import com.ats.platforms.domain.TttResult;
import com.ats.platforms.domain.User;

/**
 * @author rmeder
 * Created: Jan 23, 2007
 * 
 *
 */
public class UserJpaDaoTest extends AbstractJpaDaoTest {

	/**
	 * the logging instance for tracing 
	 */
	private static final Log LOG = LogFactory.getLog(UserJpaDaoTest.class);
	
	/**
	 * the dao for test
	 */
	private UserDao userDao = null;
	
	private RoleDao roleDao = null;
    
    private LookupDao lookupDao = null;
    
    private TttResultDao tttResultDao = null;
    private RcdStatusDao rcdStatusDao = null;
    
	
	
	/**
     * @return the rcdStatusDao
     */
    public RcdStatusDao getRcdStatusDao() {
        return this.rcdStatusDao;
    }

    /**
     * @param rcdStatusDao the rcdStatusDao to set
     */
    public void setRcdStatusDao(RcdStatusDao rcdStatusDao) {
        this.rcdStatusDao = rcdStatusDao;
    }

    /**
     * @return the tttResultDao
     */
    public TttResultDao getTttResultDao() {
        return this.tttResultDao;
    }

    /**
     * @param tttResultDao the tttResultDao to set
     */
    public void setTttResultDao(TttResultDao tttResultDao) {
        this.tttResultDao = tttResultDao;
    }

    /**
     * @return the lookupDao
     */
    public LookupDao getLookupDao() {
        return this.lookupDao;
    }

    /**
     * @param lookupDao the lookupDao to set
     */
    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    /**
	 * Test method for {@link com.ats.platforms.dao.impl.UserJpaDao#loadUserByUsername(java.lang.String)}.
	 */
	public final void testLoadUserByUsername() {
		User details = (User)this.userDao.loadUserByUsername("robert.mederer");
		
		assertNotNull(details);
		assertEquals("robert.mederer", details.getUsername());
		assertNotNull(details.getAddress());
		assertNotNull(details.getRoles());
	}

//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#clear()}.
//	 */
//	public final void testClear() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#contains(java.lang.Object)}.
//	 */
//	public final void testContains() {
//		fail("Not yet implemented");
//	}
//
	/**
	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#find()}.
	 */
	public final void testFind() {
		List<User> users = this.userDao.find();
		
		assertNotNull(users);
		assertTrue(users.size() > 0);
	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#find(java.io.Serializable)}.
//	 */
//	public final void testFindID() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#find(java.lang.Object)}.
//	 */
//	public final void testFindT() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#flush(java.lang.Object)}.
//	 */
//	public final void testFlush() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#getEntityType()}.
//	 */
//	public final void testGetEntityType() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#merge(java.lang.Object)}.
//	 */
//	public final void testMerge() {
//		fail("Not yet implemented");
//	}
//
	/**
	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#persist(java.lang.Object)}.
	 */
	public final void testPersist() {
		
		
		User u = new User();
		u.setUsername("test.user");
		u.setFirstName("test");
		u.setLastName("user");
		u.setEmail("test.user@test.de");
		u.setPassword("Secret");
		u.setConfirmPassword("Secret");
		u.setLifeMotto2("www.platforms.org");
		u.setLifeMotto("0049069765432345678");
		
		Address adr = new Address();
		adr.setAddress1("Street 1");
		adr.setCity("City");
		adr.setCountry("Country");
		adr.setPostalCode("908876");
		adr.setProvince("Province");
		u.setAddress(adr);
        
        List<Ennagram> ennagrams = this.lookupDao.getEnnagrams();
        Ennagram e = new Ennagram();
        e.setId(new Long(1));
        
        u.setPrimaryEnnagram(ennagrams.get(1));
		
		Set<Role> roles = new HashSet<Role>();
		
//		Role r1 = new Role();
//		r1.setAuthority("mega admin");
//		r1.setDescription("the mega admin to be");
//		roles.add(r1);
//		
//		Role r2 = new Role();
//		r2.setAuthority("network user");
//		r2.setDescription("the network user");
//		roles.add(r2);
		List<Role> allRoles = this.roleDao.find();
		
		for (Role role : allRoles) {
			roles.add(role);
		}
		
		u.setRoles(roles);
		this.userDao.persist(u);
//        this.userDao.flush();
//        User u2 = new User();
//        u2.setUsername("test.user");
//		this.userDao.persist(u2);
//        this.userDao.flush();
        
        List<TttResult> ttts = this.tttResultDao.find();
        List<RcdStatus> rcds = this.rcdStatusDao.find();
		
		User details = (User)this.userDao.loadUserByUsername(u.getUsername());
		
		assertNotNull(details);
		assertEquals(u.getUsername(), details.getUsername());
		assertNotNull(details.getAddress());
		assertNotNull(details.getRoles());
		
	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#refresh(java.lang.Object)}.
//	 */
//	public final void testRefresh() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#remove(java.lang.Object)}.
//	 */
//	public final void testRemoveT() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#remove(java.lang.Class, java.io.Serializable)}.
//	 */
//	public final void testRemoveClassOfQextendsRoleID() {
//		fail("Not yet implemented");
//	}
//
//	/**
//	 * Test method for {@link com.ats.platforms.dao.impl.AbstractGenericJpaDao#checkParam(java.lang.Object, java.lang.String)}.
//	 */
//	public final void testCheckParam() {
//		fail("Not yet implemented");
//	}

	/**
	 * @return the userDao
	 */
	public UserDao getUserDao() {
		return this.userDao;
	}

	/**
	 * @param userDao the userDao to set
	 */
	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	/**
	 * @return the roleDao
	 */
	public RoleDao getRoleDao() {
		return this.roleDao;
	}

	/**
	 * @param roleDao the roleDao to set
	 */
	public void setRoleDao(RoleDao roleDao) {
		this.roleDao = roleDao;
	}

}
