/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.action.login;

import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

import com.ats.platforms.domain.User;
import com.ats.platforms.user.service.UserService;

/**
 * @author rmeder
 * Created: Jan 26, 2007
 * 
 *
 */
public class RegisterAction extends AbstractAction {
    UserService service;

    /**
     * @param service the service to set
     */
    public void setService(UserService service) {
        this.service = service;
    }

    /* (non-Javadoc)
     * @see org.springframework.webflow.action.AbstractAction#doExecute(org.springframework.webflow.execution.RequestContext)
     */
    @Override
    protected Event doExecute(RequestContext ctx) throws Exception {
        service.register((User)ctx.getFlowScope().get("userData"));
        return success();
    }

}
