/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.command.ttt;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class AnswerAction extends AbstractAction {

    /* (non-Javadoc)
     * @see org.springframework.webflow.action.AbstractAction#doExecute(org.springframework.webflow.execution.RequestContext)
     */
    @Override
    protected Event doExecute(RequestContext ctx) throws Exception {
        ResourceBundle rb = ResourceBundle.getBundle("ttt-questions");
        List<String> answerValue1 = new ArrayList<String>();
        List<String> answerValue2 = new ArrayList<String>();
        for(int i = 1; i <= 40; i++) {
            answerValue1.add(rb.getString("ttt.question." + i + ".answer.1.value"));
            answerValue2.add(rb.getString("ttt.question." + i + ".answer.2.value"));
        }
        
        ctx.getFlowScope().put("answerValue1", answerValue1);
        ctx.getFlowScope().put("answerValue2", answerValue2);
        
        return success();
    }

}
