/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.command.ttt;

import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

import com.ats.platforms.ttt.service.TrivialTemperamentService;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class TemperamentAction extends AbstractAction {
    TrivialTemperamentService service;

    /**
     * @param service the service to set
     */
    public void setService(TrivialTemperamentService service) {
        this.service = service;
    }

    /* (non-Javadoc)
     * @see org.springframework.webflow.action.AbstractAction#doExecute(org.springframework.webflow.execution.RequestContext)
     */
    @Override
    protected Event doExecute(RequestContext ctx) throws Exception {
        Answers answers = (Answers)ctx.getFlowScope().get("answers");
        ctx.getFlowScope().put("temperament", service.calculateTemperament(answers.getAnswers()));
        
        return success();
    }

}
