/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.controller;

import java.awt.image.BufferedImage;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.springframework.web.bind.RequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

import com.ats.platforms.domain.PlotPoint;
import com.ats.platforms.domain.TttResult;
import com.ats.platforms.domain.User;
import com.ats.platforms.ttt.service.TrivialTemperamentService;
import com.ats.platforms.user.service.UserService;
import com.ats.platforms.webutils.ImageGenerator;
import com.ats.platforms.webutils.TTTParser;


/**
 * @author markus.lang
 * Created: 26.01.2007
 * 
 *
 */
public class ImageController extends AbstractController {
    
    private UserService userService;
    private TrivialTemperamentService tttService;

    /* (non-Javadoc)
     * @see org.springframework.web.servlet.mvc.AbstractController#handleRequestInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) throws Exception {

        String xAxis = request.getParameter("xParam");
        String yAxis = request.getParameter("yParam");
        
        //fallback if bad request params
        if (xAxis == null || xAxis.length() < 3 || "null".equals(xAxis)) {
            xAxis = "E-I";
        }
        if (yAxis == null || yAxis.length() < 3 || "null".equals(yAxis)) {
            yAxis = "S-N";
        }
        
        String x1 = xAxis.substring(0, 1);
        String x2 = xAxis.substring(2, 3);
        String y1 = yAxis.substring(0, 1);
        String y2 = yAxis.substring(2, 3);
        
        

        List<User> users = this.userService.getAllUsers();
        List<PlotPoint> pointList = new Vector<PlotPoint>();
        
        Iterator<User> userIter = users.iterator();
        
        
        TTTParser tttParser = new TTTParser();
        
        //currently x is fixed to "E-I" and y to "S-N" and all users will be displayed
        while (userIter.hasNext()) {
            User user = userIter.next();
            System.out.println(user);
            
            //ttrResult loading is not working yet :-(
            TttResult tttResult = null;
            
//            int x = tttParser.parse(tttResult.getResult(), x1, x2);
//            int y = tttParser.parse(tttResult.getResult(), y1, y2);
            
            int x = tttParser.parse("E+1N+3T+1P+2", x1, x2);
            int y = tttParser.parse("E+1N+3T+1P+2", y1, y2);
            
            int type = 0; //no contact so far
            
            pointList.add(new PlotPoint(x, y, type));
        }
        
        // add current user
        User user = this.getUser();
        TttResult tttResult = null;
        
//        int x = tttParser.parse(tttResult.getResult(), x1, x2);
//        int y = tttParser.parse(tttResult.getResult(), y1, y2);
        int x = tttParser.parse("I+5N+3F+4P+2", x1, x2);
        int y = tttParser.parse("I+5N+3F+4P+2", y1, y2);
        pointList.add(new PlotPoint(x, y, 99));
        
        //int x = tttParser.parse("E+1N+3T+1P+2", x1, x2);
        //int y = tttParser.parse("E+1N+3T+1P+2", y1, y2);
        
        
        
        // random test data should be commented out later
        //List<PlotPoint> pointList = new Vector<PlotPoint>();
        
        pointList.add(new PlotPoint(tttParser.parse("I+5N+3F+4P+2", x1, x2), tttParser.parse("I+5N+3F+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+4S+4F+3J+2", x1, x2), tttParser.parse("I+4S+4F+3J+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+7N+5T+4P+1", x1, x2), tttParser.parse("I+7N+5T+4P+1", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+3S+7F+4P+2", x1, x2), tttParser.parse("I+3S+7F+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+6N+3F+4J+10", x1, x2), tttParser.parse("I+6N+3F+4J+10", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+5N+2T+4P+2", x1, x2), tttParser.parse("I+5N+2T+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+1S+4F+4P+3", x1, x2), tttParser.parse("I+1S+4F+4P+3", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("I+0N+3F+4P+2", x1, x2), tttParser.parse("I+0N+3F+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+10N+6F+4J+4", x1, x2), tttParser.parse("E+10N+6F+4J+4", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+4N+3T+6P+2", x1, x2), tttParser.parse("E+4N+3T+6P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+5S+2F+4P+2", x1, x2), tttParser.parse("E+5S+2F+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+8N+3F+4P+5", x1, x2), tttParser.parse("E+8N+3F+4P+5", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+5N+0T+10J+2", x1, x2), tttParser.parse("E+5N+0T+10J+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+2S+3F+4P+2", x1, x2), tttParser.parse("E+2S+3F+4P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+5N+1F+3P+2", x1, x2), tttParser.parse("E+5N+1F+3P+2", y1, y2), 1));
        pointList.add(new PlotPoint(tttParser.parse("E+4N+3F+4P+2", x1, x2), tttParser.parse("E+4N+3F+4P+2", y1, y2), 1));
        
//        pointList.add(new PlotPoint(-10, -6, 1));
//        pointList.add(new PlotPoint(-1, -10, 1));
//        pointList.add(new PlotPoint(3, 5, 1));
//        pointList.add(new PlotPoint(7, 6, 3));
//        
//        pointList.add(new PlotPoint(8, -2, 2));
//        
//        pointList.add(new PlotPoint(20, 20, 1));
//        pointList.add(new PlotPoint(15, 15, 3));
//        pointList.add(new PlotPoint(10, 10, 2));
//        pointList.add(new PlotPoint(5, 5, 2));
//
//        pointList.add(new PlotPoint(-20, -20, 1));
//        pointList.add(new PlotPoint(-15, -15, 3));
//        pointList.add(new PlotPoint(-10, -10, 2));
//        pointList.add(new PlotPoint(-5, -5, 2));
        
        //pointList.add(new PlotPoint(0, 0, 99));
        
        
        ImageGenerator imageGen = new ImageGenerator();
        
        BufferedImage image = imageGen.generateImage(pointList, xAxis, yAxis);
        
        String format = "JPG";
//        try {
//            ImageIO.write(image, format, new File("C:\\temp\\test.jpg"));
//        } catch (IOException e) {
//            System.out.println(e);
//        }

//      Get the raw data to stream it to the client
        
        String filename = "image";
        response.setContentType("image/jpeg");
        // Content-disposition type "inline" will cause the jpg to be shown in the browser window.
        // The type "attachment" will cause the browser to display a download dialog instead.
        response.setHeader("Content-disposition", "inline;filename=" + filename);
        //response.setContentLength(buf.length);
        
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write(image, format, out);
        //out.write(buf);
        out.close();
        
        return null;
    }
    
    /**
     * Returns the user object from the security context.
     * 
     * @return the user object from the security context or <code>null</code> if no 
     *      authentication information is available
     * @author Robert.Mederer
     */
    public User getUser()
    {
        User theUser = null;
        // retrieve the security context associated with the current thread of execution
        SecurityContext ctx = SecurityContextHolder.getContext();
        // obtain the currently authentication information
        Authentication auth = ctx.getAuthentication();
        
        if (null != auth) 
        {
            // obtain the currently authenticated principal
            Object o =auth.getPrincipal();
            if(o instanceof User)
            {
                theUser = (User)o;
            }
        }       
        return theUser;     
        
    }

    /**
     * @return the userService
     */
    public UserService getUserService() {
        return this.userService;
    }

    /**
     * @param userService the userService to set
     */
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    /**
     * @return the tttService
     */
    public TrivialTemperamentService getTttService() {
        return this.tttService;
    }

    /**
     * @param tttService the tttService to set
     */
    public void setTttService(TrivialTemperamentService tttService) {
        this.tttService = tttService;
    }

}
