/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.validator.ttt;

import java.util.ArrayList;
import java.util.List;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import com.ats.platforms.command.ttt.Answers;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class AnswersValidator implements Validator {

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#supports(java.lang.Class)
     */
    public boolean supports(Class clazz) {
        return clazz.equals(Answers.class);
    }

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#validate(java.lang.Object, org.springframework.validation.Errors)
     */
    public void validate(Object obj, Errors errors) {
//        String[] valid = { "", "S", "N", "J", "P", "T", "F", "E", "I" };
        List<String> validAnswers = new ArrayList<String>();
        validAnswers.add("");
        validAnswers.add("S");
        validAnswers.add("N");
        validAnswers.add("J");
        validAnswers.add("P");
        validAnswers.add("T");
        validAnswers.add("F");
        validAnswers.add("E");
        validAnswers.add("I");
        Answers answers = (Answers)obj;
        for(String answer : answers.getAnswers()) {
            if(!validAnswers.contains(answer.trim().toUpperCase())) {
                errors.reject("A wrong value for the answer....");
            }
        }
    }

}
