/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.validator.ttt;

import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import com.ats.platforms.domain.user.UserVO;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class UserValidator implements Validator {

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#supports(java.lang.Class)
     */
    public boolean supports(Class clazz) {
        return clazz.equals(UserVO.class);
    }

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#validate(java.lang.Object, org.springframework.validation.Errors)
     */
    public void validate(Object obj, Errors errors) {
        UserVO user = (UserVO)obj;
        
        if(StringUtils.isBlank(user.getUsername().trim()))
            errors.rejectValue("username", "error.missing.username", "Please enter a username");
        if(StringUtils.isBlank(user.getPassword().trim()))
            errors.rejectValue("password", "error.missing.password", "Please enter a password");
    }

}
