/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.validator.user;

import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import com.ats.platforms.dao.UserDao;
import com.ats.platforms.domain.User;
import com.ats.platforms.user.service.UserService;
import com.ats.platforms.user.service.impl.LoginServiceImpl;

/**
 * @author jens.eickmeyer
 * Created: 25.01.2007
 * 
 *
 */
public class UserValidator implements Validator {
    private LoginServiceImpl service;

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#supports(java.lang.Class)
     */
    public boolean supports(Class clazz) {
        return clazz.equals(User.class);
    }

    /* (non-Javadoc)
     * @see org.springframework.validation.Validator#validate(java.lang.Object, org.springframework.validation.Errors)
     */
    public void validate(Object obj, Errors errors) {
        User user = (User)obj;
        
        validateFirstStep(user, errors);
        validateSecondStep(user, errors);
    }
    
    public void validateFirstStep(User user, Errors errors) {
        if(StringUtils.isBlank(user.getUsername().trim())) {
            errors.rejectValue("username", "error.missing.username", "Please enter a username");
        } else {
            // No good style...
            try {
                this.service.loadUserByUsername(user.getUsername());
                errors.rejectValue("username", "error.duplicate.username", "A user with the given username exists already");
            } catch (UsernameNotFoundException e) {
                // Everything is ok
            } catch (DataAccessException e) {
                // This exception should be handled
            }
        }
        if(StringUtils.isBlank(user.getPassword().trim()))
            errors.rejectValue("password", "error.missing.password", "Please enter a password");
        if(StringUtils.isBlank(user.getEmail().trim()))
            errors.rejectValue("email", "error.missing.email", "Please enter a email");
        if(StringUtils.isBlank(user.getFirstName().trim()))
            errors.rejectValue("firstName", "error.missing.firstName", "Please enter your firstname");
        if(StringUtils.isBlank(user.getLastName().trim()))
            errors.rejectValue("lastName", "error.missing.lastName", "Please enter your lastname");
        if(StringUtils.isBlank(user.getAddress().getCity().trim()))
            errors.rejectValue("address.city", "error.missing.city", "Please enter your city");
        if(StringUtils.isBlank(user.getAddress().getCountry().trim()))
            errors.rejectValue("address.country", "error.missing.country", "Please enter your country");
    }
    
    public void validateSecondStep(User user, Errors errors) {
        if(StringUtils.isBlank(user.getLifeMotto().trim()))
            errors.rejectValue("lifeMotto", "error.missing.lifemotto", "Please enter a lifemotto");
    }

    /**
     * @return the service
     */
    public LoginServiceImpl getService() {
        return this.service;
    }

    /**
     * @param service the service to set
     */
    public void setService(LoginServiceImpl service) {
        this.service = service;
    }

    
}
