/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.webutils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.imageio.ImageIO;

import com.ats.platforms.domain.PlotPoint;

/**
 * Util class responsible for generating images
 * with plotted points.
 * 
 * @author markus.lang
 * Created: 25.01.2007
 * 
 *
 */
public class ImageGenerator {
    private int hight=500;
    private int width=500;
    
    
    public BufferedImage generateImage(List<PlotPoint> plotPoints, String labelX, String labelY) {
        
        Iterator<PlotPoint> iter = plotPoints.iterator();
        int maxX=5;
        int minX=-5;
        int maxY=5;
        int minY=-5;
        
        // calculate min's and max's
        while (iter.hasNext()) {
            PlotPoint point = iter.next();
            if (maxX < point.getX()) {
                maxX = point.getX();
            }
            if (minX > point.getX()) {
                minX = point.getX();
            }
            if (maxY < point.getY()) {
                maxY = point.getY();
            }
            if (minY > point.getY()) {
                minY = point.getY();
            }
        }
        
        // calculate dimensions
        int dimensionX = Math.abs(maxX - minX);
        int dimensionY = Math.abs(maxY - minY);
        
        BufferedImage image = new BufferedImage(hight, width, BufferedImage.TYPE_INT_RGB);
        
        Graphics graphics = image.getGraphics();
        
        // generate default and bold font
        Font oldFont = graphics.getFont();
        Font newFont = new Font(oldFont.getName(), Font.BOLD, oldFont.getSize());

        // fill white background
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, hight, width);

        // draw plotting frame
        graphics.setColor(Color.BLACK);
        graphics.drawRect(90, 10, width-100, hight-100);
        
        // label min and max for y - axis
        graphics.drawLine(90, 20, 70, 20);
        graphics.drawString(String.valueOf(maxY), 30, 25);
        graphics.drawLine(90, hight - 100, 70, hight - 100);
        graphics.drawString(String.valueOf(minY), 30, hight - 95);
        
        // label min and max for x - axis
        graphics.drawLine(100, hight - 90, 100, hight - 70);
        graphics.drawString(String.valueOf(minX), 90, hight - 55);
        graphics.drawLine(width-20, hight - 90, width-20, hight - 70);
        graphics.drawString(String.valueOf(maxX), width - 50, hight - 55);
        
        graphics.setColor(Color.GRAY);
        
        // draw vertical grid
        graphics.drawLine(90, 20, width - 10, 20);
        graphics.drawLine(90, ((hight - 100 - 20) / 4) + 20, width - 10, ((hight - 100 - 20) / 4) + 20);
        graphics.drawLine(90, ((hight - 100 - 20) / 2) + 20, width - 10, ((hight - 100 - 20) / 2) + 20);
        graphics.drawLine(90, ((hight - 100 - 20) * 3 / 4) + 20, width - 10, ((hight - 100 - 20) * 3 / 4) + 20);
        graphics.drawLine(90, hight - 100, width - 10, hight - 100);
        
        
        // draw horizontal grid
        graphics.drawLine(100, 10, 100, hight - 90);
        graphics.drawLine(((width - 20 - 100) / 4) + 100, 10, ((width - 20 - 100) / 4) + 100, hight - 90);
        graphics.drawLine(((width - 20 - 100) / 2) + 100, 10, ((width - 20 - 100) / 2) + 100, hight - 90);
        graphics.drawLine(((width - 20 - 100) * 3 / 4) + 100, 10, ((width - 20 - 100) * 3 / 4) + 100, hight - 90);
        graphics.drawLine(width-20, 10, width-20, hight - 90);

        graphics.setColor(Color.BLACK);

        // label y-axis
        //text should not be to long, if it is longer than 10 then do ONE line break
        //sorry, no time for more logic here ;-)
        graphics.setFont(newFont);
        if (labelY.length() > 10) {
            graphics.drawString(labelY.substring(0, 10), 10, 100);
            graphics.drawString(labelY.substring(10, labelY.length()-1), 10, 115);
        } else {
            graphics.drawString(labelY, 10, 100);
        }
        // label x-axis
        graphics.drawString(labelX, 200, hight-40);

        graphics.setFont(oldFont);
        
        
        // start plotting here
        iter = plotPoints.iterator();
        while (iter.hasNext()) {
            PlotPoint point = iter.next();
            // set color according to RCD type
            graphics.setColor(getPaintColor(point.getType()));
            // plot one point
            graphics.fillOval(getRealPrintPointX(point.getX(), minX, dimensionX, width - 120, 95), 
                                getRealPrintPointY(point.getY(), maxY, dimensionY, hight - 120, 15), 
                                10, 10);
            
        }
        
        // draw image generation timestamp
        graphics.drawString("Generated: " + new Date(), 
            10, image.getHeight() - 10);
        // save modified image
//        String format = "JPG";
//        try {
//            ImageIO.write(image, format, new File("C:\\temp\\test.jpg"));
//        } catch (IOException e) {
//            System.out.println(e);
//        }
        return image;
    }
    
    /**
     * Return color depending on the RCD type
     * 
     * @param type
     * @return
     */
    private Color getPaintColor(int type) {
        // self = blue
        if (type == 99) {
            return Color.BLUE;
        }
        // no_contact = black
        if (type == 0) {
            return Color.BLACK;
        }
        // RCD_sent = red
        if (type == 1) {
            return Color.RED;
        }
        // RCD_received = violet
        if (type == 2) {
            return new Color(139,0,255);
        }
        // in_contact = green
        if (type == 3) {
            return Color.GREEN;
        }
        return Color.BLACK;
    }
    
    // calculate positioning for x
    private int getRealPrintPointX(int x, int minX, int dimensionX, int drawingwidht, int shift) {
        
//        System.out.println("x:" + x);
//        System.out.println("min x:" + minX);
//        System.out.println("dim x:" + dimensionX);
//        System.out.println("drawwidth:" + drawingwidht);
//        System.out.println("shift x:" + shift);
        double first = ((double)drawingwidht / (double)dimensionX);
        int result = (int)(first * (x - minX)) + shift; 
//        System.out.println("result x:" + result);
        return result;
    }
    
    // calculate positioning for y
    private int getRealPrintPointY(int y, int maxY, int dimensionY, int drawinghight, int shift) {
        
//        System.out.println("y:" + y);
//        System.out.println("max y:" + maxY);
//        System.out.println("dim y:" + dimensionY);
//        System.out.println("drawhight:" + drawinghight);
//        System.out.println("shift y:" + shift);
        double first = ((double)drawinghight / (double)dimensionY);
        int result = (int)((double)first * ((-1 * y) + maxY)) + shift;
//        System.out.println("result y:" + result);
        return result;
    }
}
