/**
 * Copyright Accenture 2006-2007. All rights reserved.
 *
 */
/**
 * 
 * Subversion meta data:
 * $Id$
 * $HeadURL$
 *
 */
package com.ats.platforms.webutils;

/**
 * Helper to parse TTT results to coordinates, needed for plotting
 * 
 * @author markus.lang
 * Created: 26.01.2007
 * 
 *
 */
public class TTTParser {

    /**
     * Quick solution!
     * "Checks" for two digits, if not checks for 1 digit, if not 0
     * 
     * @param tttResult
     * @param plusValue
     * @param minusValue
     * @return parsingResult
     */
    public int parse(String tttResult, String plusValue, String minusValue) {
        
        
        int result = 0;
        
        if (tttResult.indexOf(plusValue) > -1) {
            try {
                // 2 digits?
                result = Integer.parseInt(tttResult.substring(tttResult.indexOf(plusValue)+2, tttResult.indexOf(plusValue)+4));
            } catch (Exception e) {
                //e.printStackTrace();
                try {
                    // 1 digit?
                    result = Integer.parseInt(tttResult.substring(tttResult.indexOf(plusValue)+2, tttResult.indexOf(plusValue)+3));
                } catch (Exception e1) {
                    //e.printStackTrace();
                    result = 0;
                }
            }
            return result;
        } else if (tttResult.indexOf(minusValue) > -1) {
            try {
                // 2 digits?
                result = Integer.parseInt(tttResult.substring(tttResult.indexOf(minusValue)+2, tttResult.indexOf(minusValue)+4));
            } catch (Exception e) {
                //e.printStackTrace();
                try {
                    // 1 digit?
                    result = Integer.parseInt(tttResult.substring(tttResult.indexOf(minusValue)+2, tttResult.indexOf(minusValue)+3));
                } catch (Exception e1) {
                    //e.printStackTrace();
                    result = 0;
                }
            }
            return (-1) * result;
        } else return 0;
        
    }

}
