#!/usr/bin/perl
use strict;


use CGI::Carp qw( fatalsToBrowser );

use PbT qw{ -Engine=CGI -TemplateEngine=TT };

use Gantry::Engine::CGI;

my $cgi = Gantry::Engine::CGI->new( {
    config => {
        GantryConfInstance => 'pbt',

    },
    locations => {
        '/' => 'PbT',
        '/user' => 'PbT::UserData',
        '/like' => 'PbT::LikeData',
        '/tt_question' => 'PbT::TTQuestion',
        '/tt_answer' => 'PbT::TTAnswer',
        '/tt_summary' => 'PbT::TTSummary',
        '/enne' => 'PbT::Enne',
        '/visible' => 'PbT::Visible',
        '/soap' => 'PbT::Soap',
        '/country' => 'PbT::Country',
    },
} );

$cgi->dispatch();

if ( $cgi->{config}{debug} ) {
    foreach ( sort { $a cmp $b } keys %ENV ) {
        print "$_ $ENV{$_}<br />\n";
    }
}
