# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package PbT::GEN::Enne;

use strict;

use base 'PbT';

use PbT::Model::enne qw(
    $ENNE
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Enne' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'Rel To',
            'Rel To',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $ENNE->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->rel_to->foreign_display(),
                    $row->rel_to->foreign_display(),
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $ENNE->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'description',
                label => 'Description',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{enne},
                name => 'rel_to',
                label => 'Rel To',
                type => 'text',
                is => 'int4',
            },
            {
                options => $selections->{enne},
                name => 'rel_from',
                label => 'Rel From',
                type => 'text',
                is => 'int4',
            },
        ],
    };
} # END form

1;

=head1 NAME

PbT::GEN::Enne - generated support module for PbT::Enne

=head1 SYNOPSIS

In PbT::Enne:

    use base 'PbT::GEN::Enne';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in PbT::Enne to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

