# This file was origanally subject to regeneration.  Now it has been changed
# to accomodate an externally presented WSDL.
package PbT::GEN::Soap;

use strict;

#-----------------------------------------------------------------
# Inherit from the app's base controller
#-----------------------------------------------------------------

use PbT qw(
    -PluginNamespace=PbT::Soap
    SOAPMP20
);

our @ISA = qw( PbT );

#-----------------------------------------------------------------
# Bring in other modules
#-----------------------------------------------------------------

use SOAP::Lite;

# We need our own soap_out for complex types.
#    soap_out
use Gantry::Plugins::SOAPMP20 qw(
    soap_in
    do_main
    do_wsdl
    return_error
);

#-----------------------------------------------------------------
# $self->soap_out(  )
#-----------------------------------------------------------------
sub soap_out {
    my $self   = shift;
    my $action = shift;
    my $data   = shift;

    my $descr  = $self->get_soap_ops();

    my $this_op;
    OP:
    foreach my $op ( @{ $descr->{ operations } } ) {
        next OP unless $op->{ name } eq $action;
        $this_op = $op;
        last OP;
    }

    if ( not defined $this_op ) {
        die "Couldn't find description of $action operation.";
    }

    my @soap_data;
    foreach my $return_descr ( @{ $this_op->{ returns } } ) {

        my $data_key   = $return_descr->{ name };
        my $data_type  = $return_descr->{ type };

        my $perl_value = $data->{ $data_key };

        my $complex_type = $data_type;
        $complex_type    =~ s/impl://;

        if ( defined $descr->{ types }{ $complex_type } ) {
            # dispatch to custom type handler
            my $type_descr   = $descr->{ types }{ $complex_type };

            my $handler      = $type_descr->{ wsdl_type };
            $handler         = "_soap_out_$handler";

            my $chewy_center;
            {
                no strict 'refs';
                $chewy_center = $handler->(
                    {
                        value     => $perl_value,
                        wsdl_type => $type_descr->{ wsdl_type },
                        elements  => $type_descr->{ elements },
                        soap_ops  => $descr,
                    }
                );
            }

            push @soap_data, SOAP::Data->new(
                name  => $complex_type,
                value => $chewy_center,
                type  => $data_type,
            );
        }
        elsif ( $data_type =~ /\[\]/i ) {  # do you see brackets
            # dispatch to array handler
            my $array_contents = _soap_out_array->(
                    $perl_value,
                    $data_type,
            );

            push @soap_data, SOAP::Data->new(
                name  => $complex_type,
                value => $array_contents,
                type  => $data_type,
            );
        }
        else { # simple type, do it now
            push @soap_data, SOAP::Data->new(
                name  => $data_key,
                type  => $data_type,
                value => $perl_value,  # no need to convert
            );
        }
    }

    use Data::Dumper; warn Dumper( \@soap_data );

    my $serializer = SOAP::Serializer->new();
    my $output     = $serializer->envelope(
        'method' => $action . "Response", @soap_data
    );

    return $output;
} # END soap_out

sub _soap_out_array {
    my $values       = shift;
    my $element_type = shift;

    return SOAP::Data->new(
        name  => 'element',
        type  => $element_type,
        value => @{ $values },
    );
}

sub _soap_out_complex_arrays {
    my $opts         = shift;
    my $name         = shift;

    my $value        = $opts->{ value };
    my $wsdl_type    = $opts->{ wsdl_type };

    my $element_type = $wsdl_type;
    $element_type    =~ s/\[|\]//;

    my $array_contents = _soap_out_array( $value, $element_type );

    return SOAP::Data->new(
        name  => $name,
        type  => $wsdl_type,
        value => $array_contents,
    );
}

sub _soap_out_Memberinfo {
    my $opts      = shift;

    my $value     = $opts->{ value     };
    my $wsdl_type = $opts->{ wsdl_type };
    my $elements  = $opts->{ elements  };
    my $soap_ops  = $opts->{ soap_ops  };

    my @seq_elements;

    foreach my $element ( @{ $elements } ) {
        my $complex_type = $element->{ type };
        $complex_type    = s/.*://;

        if ( defined $soap_ops->{ types }{ $complex_type } ) {
            # dispatch to custom type handler
            my $type_descr   = $soap_ops->{ types }{ $complex_type };

            my $handler      = $type_descr->{ wsdl_type };
            $handler         = "_soap_out_$handler";

            my $chewy_center;
            {
                no strict 'refs';
                $chewy_center = $handler->(
                    {
                        value     => $value,
                        wsdl_type => $type_descr->{ wsdl_type },
                        soap_ops  => $soap_ops,
                    }
                );
            }

            push @seq_elements, SOAP::Data->new(
                name  => $complex_type,
                value => $chewy_center,
                type  => $element->{ type },
            );
        }
        else {
            push @seq_elements, SOAP::Data->new(
                name  => $element->{ name },
                type  => $element->{ type },
                value => $value->{ $element->{ name } },
            );
        }
    }

    return SOAP::Data->new(
        name  => 'Memberinfo',
        type  => $wsdl_type,
        value => @seq_elements,
    );
}

sub _soap_out_ArrayOf_soapenc_string {
    return _soap_out_complex_arrays( @_, 'ArrayOf_soapenc_string' );
}

sub _soap_out_ArrayOfMemberinfo {
    return _soap_out_complex_arrays( @_, 'ArrayOfMemberinfo' );
}

#-----------------------------------------------------------------
# $self->namespace(  )
#-----------------------------------------------------------------
sub namespace {
    return 'PbT::Soap';
} # END namespace

#-----------------------------------------------------------------
# $self->get_soap_ops
#-----------------------------------------------------------------
sub get_soap_ops {
    my $self = shift;

    return {
        soap_name      => 'PbT',
        location       => $self->location,
        namespace_base => 'DefaultNamespace',
        types          => {
            'ArrayOf_soapenc_string' => {
                wsdl_type => 'soapenc:string[]',
            },
            'ArrayOfMemberinfo' => {
                wsdl_type => 'impl:Memberinfo[]',
            },
            'Memberinfo' => {
                wsdl_type => 'Memberinfo',
                elements  => [
                    {
                        name     => 'country',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'dislikes',
                        nillable => 1,
                        type     => 'impl:ArrayOf_soapenc_string',
                    },
                    {
                        name     => 'emailAddress',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'enneagramtype1',
                        type     => 'xsd:int',
                    },
                    {
                        name     => 'enneagramtype2',
                        type     => 'xsd:int',
                    },
                    {
                        name     => 'fullname',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'gpsCoordinates',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'likes',
                        nillable => 1,
                        type     => 'impl:ArrayOf_soapenc_string',
                    },
                    {
                        name     => 'motto1',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'motto2',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'registrationTime',
                        nillable => 1,
                        type     => 'xsd:dateTime',
                    },
                    {
                        name     => 'town',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'tttTestTime',
                        nillable => 1,
                        type     => 'xsd:dateTime',
                    },
                    {
                        name     => 'tttType',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                    {
                        name     => 'username',
                        nillable => 1,
                        type     => 'soapenc:string',
                    },
                ],
            },
        },
        operations     => [
            {
                name => 'clearDatabase',
                expects => [
                ],
                returns => [
                ],
            },
            {
                name => 'getMemberinfo',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'username', type => 'soapenc:string' },
                ],
                returns => [
                    { name => 'getMemberinfoReturn', type => 'impl:Memberinfo' },
                ],
            },
            {
                name => 'getMemberlist',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'username', type => 'soapenc:string' },
                    { name => 'rcdStatus', type => 'soapenc:string' },
                ],
                returns => [
                    { name => 'getMemberlistReturn', type => 'impl:ArrayOfMemberinfo' },
                ],
            },
            {
                name => 'getMemberlistGraphic',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'xSize', type => 'xsd:int' },
                    { name => 'ySize', type => 'xsd:int' },
                    { name => 'xVariable', type => 'soapenc:string' },
                    { name => 'yVariable', type => 'soapenc:string' },
                    { name => 'username', type => 'soapenc:string' },
                    { name => 'rcdStatus', type => 'soapenc:string' },
                ],
                returns => [
                    { name => 'getMemberlistGraphicReturn', type => 'soapenc:base64Binary' },
                ],
            },
            {
                name => 'login',
                expects => [
                    { name => 'username', type => 'soapenc:string' },
                    { name => 'password', type => 'soapenc:string' },
                ],
                returns => [
                    { name => 'loginReturn', type => 'soapenc:string' },
                ],
            },
            {
                name => 'logout',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                ],
                returns => [
                ],
            },
            {
                name => 'searchForMembers',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'noContact', type => 'soapenc:string' },
                    { name => 'noRcdSent', type => 'xsd:boolean' },
                    { name => 'newlyRegistered', type => 'xsd:boolean' },
                    { name => 'newlyRegisteredSinceDays', type => 'xsd:int' },
                    { name => 'inMyCountry', type => 'xsd:boolean' },
                    { name => 'maxKilometersAway', type => 'xsd:int' },
                    { name => 'tttTypes', type => 'impl:ArrayOf_soapenc_string' },
                    { name => 'myEnneagramType1', type => 'xsd:boolean' },
                    { name => 'myEnneagramType', type => 'xsd:boolean' },
                    { name => 'relatedEnneagramType', type => 'xsd:boolean' },
                    { name => 'mottoContains', type => 'soapenc:string' },
                    { name => 'minLikesShared', type => 'xsd:int' },
                    { name => 'minDislikesShared', type => 'xsd:int' },
                    { name => 'maxLikesDisliked', type => 'xsd:int' },
                    { name => 'maxDislikesLiked', type => 'xsd:int' },
                ],
                returns => [
                    { name => 'searchForMembersReturn', type => 'impl:ArrayOfMemberinfo' },
                ],
            },
            {
                name => 'searchForMembersGraphic',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'xSize', type => 'xsd:int' },
                    { name => 'ySize', type => 'xsd:int' },
                    { name => 'xVariable', type => 'soapenc:string' },
                    { name => 'yVariable', type => 'soapenc:string' },
                    { name => 'noContact', type => 'soapenc:string' },
                    { name => 'noRcdSent', type => 'xsd:boolean' },
                    { name => 'newlyRegistered', type => 'xsd:boolean' },
                    { name => 'newlyRegisteredSinceDays', type => 'xsd:int' },
                    { name => 'inMyCountry', type => 'xsd:boolean' },
                    { name => 'maxKilometersAway', type => 'xsd:int' },
                    { name => 'tttTypes', type => 'impl:ArrayOf_soapenc_string' },
                    { name => 'myEnneagramType1', type => 'xsd:boolean' },
                    { name => 'myEnneagramType', type => 'xsd:boolean' },
                    { name => 'relatedEnneagramType', type => 'xsd:boolean' },
                    { name => 'mottoContains', type => 'soapenc:string' },
                    { name => 'minLikesShared', type => 'xsd:int' },
                    { name => 'minDislikesShared', type => 'xsd:int' },
                    { name => 'maxLikesDisliked', type => 'xsd:int' },
                    { name => 'maxDislikesLiked', type => 'xsd:int' },
                ],
                returns => [
                    { name => 'searchForMembersGraphicReturn', type => 'soapenc:base64Binary' },
                ],
            },
            {
                name => 'sendRcd',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'username', type => 'soapenc:string' },
                    { name => 'positive', type => 'xsd:boolean' },
                ],
                returns => [
                ],
            },
            {
                name => 'submitMemberinfo',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'username', type => 'soapenc:string' },
                    { name => 'password', type => 'soapenc:string' },
                    { name => 'fullname', type => 'soapenc:string' },
                    { name => 'emailAddress', type => 'soapenc:string' },
                    { name => 'town', type => 'soapenc:string' },
                    { name => 'country', type => 'soapenc:string' },
                    { name => 'motto1', type => 'soapenc:string' },
                    { name => 'motto2', type => 'soapenc:string' },
                    { name => 'likes', type => 'impl:ArrayOf_soapenc_string' },
                    { name => 'dislikes', type => 'impl:ArrayOf_soapenc_string' },
                    { name => 'gpsCoordinates', type => 'soapenc:string' },
                    { name => 'enneagramtype1', type => 'xsd:int' },
                    { name => 'enneagramtype2', type => 'xsd:int' },
                ],
                returns => [
                ],
            },
            {
                name => 'takeTtt',
                expects => [
                    { name => 'sessionId', type => 'soapenc:string' },
                    { name => 'answers', type => 'soapenc:string' },
                ],
                returns => [
                    { name => 'takeTttReturn', type => 'soapenc:string' },
                ],
            },
        ],
    };
} # END get_description

1;

=head1 NAME

PbT::GEN::Soap - generated support module for PbT::Soap

=head1 SYNOPSIS

In PbT::Soap:

    use base 'PbT::GEN::Soap';

=head1 DESCRIPTION

This module was generated by bigtop but is no longer subject to regeneration.
Use it in PbT::Soap to provide the methods below.  Feel free to override them.

=head1 METHODS

=over 4

=item namespace

=item get_soap_ops

=item soap_out


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

