# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package PbT::GEN::TTAnswer;

use strict;

use base 'PbT';

use PbT::Model::tt_answer qw(
    $TT_ANSWER
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Tt Answer' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'User Data',
            'Tt Question',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $TT_ANSWER->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->user_data->foreign_display(),
                    $row->tt_question->foreign_display(),
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $TT_ANSWER->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                options => $selections->{user_data},
                name => 'user_data',
                label => 'User Data',
                type => 'select',
                is => 'int4',
            },
            {
                options => $selections->{tt_question},
                name => 'tt_question',
                label => 'Tt Question',
                type => 'select',
                is => 'int4',
            },
            {
                options => $selections->{tt_summary},
                name => 'tt_summary',
                label => 'Tt Summary',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'response',
                label => 'Response',
                type => 'text',
                is => 'char(1)',
            },
            {
                name => 'response_type',
                label => 'Response Type',
                type => 'text',
                is => 'char(1)',
            },
        ],
    };
} # END form

1;

=head1 NAME

PbT::GEN::TTAnswer - generated support module for PbT::TTAnswer

=head1 SYNOPSIS

In PbT::TTAnswer:

    use base 'PbT::GEN::TTAnswer';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in PbT::TTAnswer to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

