# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package PbT::GEN::TTSummary;

use strict;

use base 'PbT';

use PbT::Model::tt_summary qw(
    $TT_SUMMARY
);
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Tt Summary' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'Created',
            'Active',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $TT_SUMMARY->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->created,
                    $row->active,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $TT_SUMMARY->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'tt_summary',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        javascript => $self->calendar_month_js( 'tt_summary' ),
        fields     => [
            {
                options => $selections->{user_data},
                name => 'user_data',
                label => 'User Data',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'active',
                label => 'Active',
                type => 'text',
                is => 'boolean',
            },
            {
                name => 'extrovert',
                label => 'Extrovert',
                type => 'text',
                is => 'int2',
            },
            {
                name => 'sensing',
                label => 'Sensing',
                type => 'text',
                is => 'int2',
            },
            {
                name => 'thinking',
                label => 'Thinking',
                type => 'text',
                is => 'int2',
            },
            {
                name => 'judging',
                label => 'Judging',
                type => 'text',
                is => 'int2',
            },
            {
                name => 'summary_text',
                label => 'Summary Text',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'short_summary',
                label => 'Short Summary',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form

1;

=head1 NAME

PbT::GEN::TTSummary - generated support module for PbT::TTSummary

=head1 SYNOPSIS

In PbT::TTSummary:

    use base 'PbT::GEN::TTSummary';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in PbT::TTSummary to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

