# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package PbT::GEN::UserData;

use strict;

use base 'PbT';

use PbT::Model::user_data qw(
    $USER_DATA
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'User' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'User Name',
            'Full Name',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $USER_DATA->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->user_name,
                    $row->full_name,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $USER_DATA->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'user_name',
                label => 'User Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'full_name',
                label => 'Full Name',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'email',
                label => 'Email',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'town',
                label => 'Town',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{country},
                name => 'country',
                label => 'Country',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'life_motto',
                label => 'Life Motto',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'password',
                optional => 1,
                label => 'Password',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'secondary_life_motto',
                optional => 1,
                label => 'Secondary Life Motto',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'GPS_latitude',
                optional => 1,
                label => 'GPS Latitude',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'GPS_longitude',
                optional => 1,
                label => 'GPS Longitude',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{enne},
                name => 'enne_primary',
                label => 'Enne Primary',
                type => 'select',
                is => 'int4',
            },
            {
                options => $selections->{enne},
                name => 'enne_secondary',
                label => 'Enne Secondary',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'last_logged_out',
                is => 'datetime',
            },
        ],
    };
} # END form

1;

=head1 NAME

PbT::GEN::UserData - generated support module for PbT::UserData

=head1 SYNOPSIS

In PbT::UserData:

    use base 'PbT::GEN::UserData';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in PbT::UserData to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

