package PbT::Model;
use strict; use warnings;

use base 'DBIx::Class::Schema';

use PbT::GENModel;

sub get_db_options {
    return { AutoCommit => 1 };
}

1;

=head1 NAME

PbT::Model - schema class for PbT

=head1 SYNOPSIS

In your base module:

    use PbT::Model;
    sub schema_base_class { return 'PbT::Model'; }
    use Gantry::Plugins::DBIxClassConn qw( get_schema );
    use PbT::Model::user_data qw( $USER );
    use PbT::Model::like_data qw( $LIKE );
    use PbT::Model::tt_question qw( $TT_QUESTION );
    use PbT::Model::tt_answer qw( $TT_ANSWER );
    use PbT::Model::tt_summary qw( $TT_SUMMARY );
    use PbT::Model::enne qw( $ENNE );
    use PbT::Model::visible qw( $VISIBLE );

There are other tables which came after this was generated.

=head1 DESCRIPTION

This is the DBIx::Class::Schema base module for the PbT app.

=over 4

=item get_db_options

The generated version sets AutoCommit to 1, this assumes that you will
do all transaction work via the DBIx::Class API.

=back

=head1 DEPENDENCIES

    Gantry::Utils::DBIxClass
    PbT::GENModel

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
