package PbT::Model::tt_summary;
use strict; use warnings;

use base 'Gantry::Utils::DBIxClass', 'Exporter';

use PbT::Model::GEN::tt_summary;
use Date::Simple;

our $TT_SUMMARY = 'PbT::Model::tt_summary';

our @EXPORT_OK = ( '$TT_SUMMARY' );

__PACKAGE__->load_components( qw/ InflateColumn::DateTime PK::Auto Core / );
__PACKAGE__->table( 'tt_summary' );

__PACKAGE__->add_columns(
    id => {},
    created => {
       data_type => 'datetime',
    },
    user_data => {},
    active => {},
    extrovert => {},
    sensing => {},
    thinking => {},
    judging => {},
    summary_text => {},
    short_summary => {},
);

__PACKAGE__->set_primary_key( 'id' );
__PACKAGE__->belongs_to( user_data => 'PbT::Model::user_data' );
__PACKAGE__->base_model( 'PbT::Model' );

1;

=head1 NAME

PbT::Model::tt_summary - model for tt_summary table (stub part)

=head1 DESCRIPTION

This model inherits from its generated helper, which inherits from
Gantry::Utils::DBIxClass.  It was generated by Bigtop, but is
NOT subject to regeneration.

=head1 METHODS (mixed in from PbT::Model::GEN::tt_summary)

You may use all normal Gantry::Utils::DBIxClass methods and the
ones listed here:

=over 4

=item get_foreign_display_fields

=item get_foreign_tables

=item foreign_display

=item table_name

=back

=cut
