package PbT::Soap;

use strict;

use base 'PbT::GEN::Soap';

use PbT::Test;

use PbT::Model;

#-----------------------------------------------------------------
# $self->namespace(  )
#-----------------------------------------------------------------
# This method supplied by PbT::GEN::Soap

#-----------------------------------------------------------------
# $self->get_soap_ops(  )
#-----------------------------------------------------------------
# This method supplied by PbT::GEN::Soap

#-----------------------------------------------------------------
# $self->clearDatabase(  )
#-----------------------------------------------------------------
sub clearDatabase {
    my ( $self, $input ) = @_;

    my $schema = $self->get_schema;

    my $dbh    = $schema->storage->dbh();

    my $tables = join ', ', qw(
        user_data
        like_data
        user_data_like_data
        tt_answer
        tt_summary
        enne
        visible
    );

    $dbh->do( "TRUNCATE $tables" );

    return {};

} # END clearDatabase

my %member_info_wsdl = (
    emailAddress        => 'email',
    fullname            => 'full_name',
    motto1              => 'life_motto',
    motto2              => 'secondary_life_motto',
    registrationTime    => 'created',
    town                => 'town',
    username            => 'user_name',
    enneagramtype1      => 'enne_primary',
    enneagramtype2      => 'enne_secondary',
);

#-----------------------------------------------------------------
# $self->getMemberinfo(  )
#-----------------------------------------------------------------
sub getMemberinfo {
#    my ( $self, $input ) = @_;
#
#    my $sch = $self->get_schema;
#
#    my $db_sessions = $self->db_sessions();
#    my $user_id     = $db_sessions->{ $input->{ sessionId } };
#
#    my $target_user = $sch->resultset( 'user_data' )->search(
#        { user_name => $input->{ username } }
#    )->next;
#
#    if ( not defined $target_user ) {
#        die "No such user '$input->{ username }'\n";
#    }
#
#    my %member_info;
#
#    PARAM:
#    foreach my $wsdl_param ( keys %member_info_wsdl ) {
#        next PARAM unless $wsdl_param;
#
#        $member_info{ $wsdl_param } =
#                $target_user->{ $member_info_wsdl{ $wsdl_param } };
#    }
#
#    # Special ed. children:
#    # ... country
#    eval {
#        $member_info{ country } = $target_user->country->name;
#    };
#    $member_info{ country } = '' if ( $@ );
#
#    # ...gpsCoordinates
#    $member_info{ gpsCoordinates } = $self->gps_display(
#            $target_user->{ GPS_longitude },
#            $target_user->{ GPS_latitude  },
#    );
#
#    # ... likes
#    $member_info{ likes } = [];
#    # ... dislikes
#    $member_info{ dislikes } = [];
#
#    # ... tttTestTime
#    # ... tttType
#
#    my $tt_summary_row = $sch->resultset( 'tt_summary' )->search(
#        { user_data => $target_user->id, active => 't' }
#    )->next;
#
#    eval {
#        $member_info{ tttTestTime } = $tt_summary_row->created;
#    };
#    $member_info{ tttTestTime } = '' if ( $@ );
#
#    eval {
#        $member_info{ tttType     } = $tt_summary_row->short_summary;
#    };
#    $member_info{ tttType     } = '' if ( $@ );
#
#    my $in_contact = $self->in_contact( $user_id, $target_user->id );
#
#    if ( not $in_contact ) {
#        delete $member_info{ email     };
#        delete $member_info{ full_name };
#    }
#
#    return \%member_info;
} # END getMemberinfo

#-----------------------------------------------------------------
# $self->getMemberlist(  )
#-----------------------------------------------------------------
sub getMemberlist {
    my ( $self, $input ) = @_;
} # END getMemberlist

#-----------------------------------------------------------------
# $self->getMemberlistGraphic(  )
#-----------------------------------------------------------------
sub getMemberlistGraphic {
    my ( $self, $input ) = @_;
} # END getMemberlistGraphic

#-----------------------------------------------------------------
# $self->login(  )
#-----------------------------------------------------------------
sub login {
    my ( $self, $input ) = @_;

    my $sch       = $self->get_schema();

    my $user = $sch->resultset( 'user_data' )->search( { 
            'user_name'   => $input->{ username },
            'password'    => $input->{ password },
            } )->next;

    if ( $user ) {
        # set session
        my $session_id  = time . rand( 6 );
        my $db_sessions = $self->db_sessions();
        # return session id
        $$db_sessions{$session_id} = $user->id;

        return {
            loginReturn => $session_id,
        };
    }
    else {
        die "invalid login";
    }

} # END login

#-----------------------------------------------------------------
# $self->logout(  )
#-----------------------------------------------------------------
sub logout {
    my ( $self, $input ) = @_;

    my $db_sessions = $self->db_sessions();

    delete $db_sessions->{ $input->{ sessionId } };

    return {}
} # END logout

#-----------------------------------------------------------------
# $self->searchForMembers(  )
#-----------------------------------------------------------------
sub searchForMembers {
    my ( $self, $input ) = @_;
} # END searchForMembers

#-----------------------------------------------------------------
# $self->searchForMembersGraphic(  )
#-----------------------------------------------------------------
sub searchForMembersGraphic {
    my ( $self, $input ) = @_;
} # END searchForMembersGraphic

#-----------------------------------------------------------------
# $self->sendRcd(  )
#-----------------------------------------------------------------
sub sendRcd {
    my ( $self, $input ) = @_;
} # END sendRcd

my %member_from_wsdl = (
    username        => 'user_name',
    password        => 'password',
    fullname        => 'full_name',
    emailAddress    => 'email',
    town            => 'town',
    motto1          => 'life_motto',
    motto2          => 'secondary_life_motto',
    enneagramtype1  => 'enne_primary',
    enneagramtype2  => 'enne_secondary',
);

#-----------------------------------------------------------------
# $self->submitMemberinfo(  )
#-----------------------------------------------------------------
sub submitMemberinfo {
    my ( $self, $input ) = @_;

    my $sch = $self->get_schema;

    my %new_data;

    # Map input data to our column names...

    # ...regular fields
    REGULAR_COLUMN:
    foreach my $wsdl_field ( keys %member_from_wsdl ) {
        next REGULAR_COLUMN
            if ( not $input->{ $wsdl_field }
                        or
                 ref( $input->{ $wsdl_field } ) eq 'HASH'
            );

        $new_data{ $member_from_wsdl{ $wsdl_field } } =
                $input->{ $wsdl_field };
    }

    # ...gpsCoordinates
    ( $new_data{ GPS_longitude }, $new_data{ GPS_latitude } ) =
            $self->gps_split_numeric( $input->{ gpsCoordinates } ); 

    # ...country
    my $country_row = $sch->resultset( 'country' )->search(
        { name => $input->{ country } }
    )->next;

    if ( $country_row ) {
       $new_data{ country } = $country_row->id;
    }

    if ( $self->{ sessionId } ) { # update for existing user
        delete $new_data{ user_name }; # just in case
    }
    else { # new user
        # make sure user name is unique
        my $user_row = $sch->resultset( 'user_data' )->search(
            { user_name => $input->{ username } }
        )->next;

        if ( $user_row ) {
            die "User name '$input->{ username }' already in use\n";
        }

        my $new_user = $sch->resultset( 'user_data' )->create( \%new_data );
        my $user_id  = $new_user->id;

        # ...likes/dislikes
        if   ( ref( $input->{ likes } eq 'ARRAY' )
                    and
               scalar ( @{ $input->{ likes    } } )
        ) {
            $self->make_likes( $user_id, $input->{ likes }, 't' );
        }

        if ( ref( $input->{ dislikes } eq 'ARRAY' )
                    and
             scalar ( @{ $input->{ dislikes } } )
        ) {
            $self->make_likes( $user_id, $input->{ dislikes }, 'f' );
        }
    }

} # END submitMemberinfo

#-----------------------------------------------------------------
# $self->takeTtt(  )
#-----------------------------------------------------------------
sub takeTtt {
    my ( $self, $input ) = @_;

    my $db_sessions = $self->db_sessions();
    my $user_id     = $db_sessions->{ $input->{ sessionId } };

    # make a hash that looks like the one the web forms build
    my %param_spoof;

    my $count   = 1;
    ANSWER:
    foreach my $answer ( split //, $input->{ answers } ) {
        next ANSWER unless $answer;  # just skip blanks outright
        $param_spoof{ "q$count" } = $answer;
        $count++;
    }

    my $fields = {
        user_data => $user_id,
        created   => 'now',
        active    => 't',
    };

    PbT::Test::calculate_personality( $self, $fields, \%param_spoof );

    $self->get_schema->resultset( 'tt_summary' )->create( $fields );

    return {
        takeTttReturn => $fields->{ summary_text }
    };

} # END takeTtt

1;

=head1 NAME

PbT::Soap - A controller in the PbT application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use PbT::Soap;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'PbT::Soap',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use PbT::Soap;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler PbT::Soap
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module provides all the SOAP support of the PbT application.

=head1 METHODS

All of these methods respond to requests specified in the customer
supplied WSDL file.

=over 4

=item clearDatabase

No this should not remain for production deployment.  It kills all data
from all tables, except countries and personality survey.

Testing this routine is no fun for colleagues relying on the data.

=item getMemberinfo

=item getMemberlist

=item getMemberlistGraphic

=item login

=item logout

=item searchForMembers

=item searchForMembersGraphic

=item sendRcd

=item submitMemberinfo

=item takeTtt

=item schema_base_class

=item get_orm_helper


=back


=head1 METHODS INHERITED FROM PbT::GEN::Soap

=over 4

=item namespace

=item get_soap_ops


=back


=head1 DEPENDENCIES

    PbT
    PbT::GEN::Soap
    Gantry::Plugins::SOAPMP20

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
