package PbT::Status;

use strict;
use Gantry::Utils::CRUDHelp;

use base 'PbT';

use PbT::Model;
sub schema_base_class { return 'PbT::Model'; }
use Gantry::Plugins::DBIxClassConn qw( get_schema );

#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;
    
    $self->stash->view->template( 'status.tt' );    
    
    my %param = $self->get_param_hash();        
    my $sch   = $self->get_schema();

	my $order_mapping = {
		1 => 'modified DESC',
		2 => 'user.nickname',
		3 => 'user.state',
		4 => 'user.country',
		5 => 'user.ident',
	};	

	$param{page}  ||= 1;
	$param{order} ||= 1;
	
    if ( $self->is_post() ) {                
        
        my $str = $param{str};
                    
        my $dta = {
            store_display  => 1,
            -or => [
                tags => { 'like', "%$str%" },
            ],
        };             

        my $result_rows = $sch->resultset( 'user_tshirt' )->search( 
            $dta,
    		{
    			page => $param{page},
    			rows => 20,
    			order_by => $order_mapping->{ $param{order} }
    		}            
        );
        
        
        $self->stash->view->template( 'searchResults.tt' );              
        $self->stash->view->data( {
            page    => $result_rows->pager,
            results => $result_rows
        } );
                        
        return();
    }

    $self->stash->view->data( { } );       
}

1;

=head1 NAME

PbT::Status - A search controller in the PbT application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use PbT::Status;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/search' => 'PbT::Status',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use PbT::Status;
    </Perl>

    <Location /search>
        SetHandler  perl-script
        PerlHandler PbT::Status
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module handles which users are in contact.

=head1 METHODS

=over 4

=item do_main

=item schema_base_class

=back


=head1 DEPENDENCIES

    PbT
    Gantry::Utils::CRUDHelp

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
