package PbT::TTQuestion;

use strict;

use base 'PbT::GEN::TTQuestion';

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
    write_file
);

use PbT::Model::tt_question qw(
    $TT_QUESTION
);
use PbT::Model;
sub schema_base_class { return 'PbT::Model'; }
use Gantry::Plugins::DBIxClassConn qw( get_schema );

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
# This method supplied by PbT::GEN::TTQuestion

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method supplied by PbT::GEN::TTQuestion


#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $TT_QUESTION;
}

#-----------------------------------------------------------------
# get_orm_helper( )
#-----------------------------------------------------------------
sub get_orm_helper {
    return 'Gantry::Plugins::AutoCRUDHelper::DBIxClass';
}

#-----------------------------------------------------------------
# text_descr( )
#-----------------------------------------------------------------
sub text_descr     {
    return 'tt question';
}

1;

=head1 NAME

PbT::TTQuestion - A controller in the PbT application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use PbT::TTQuestion;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'PbT::TTQuestion',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use PbT::TTQuestion;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler PbT::TTQuestion
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module is the admin interface to the tt_question table (not publically
exposed).

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item schema_base_class

=item get_orm_helper


=back


=head1 METHODS INHERITED FROM PbT::GEN::TTQuestion

=over 4

=item do_main

=item form


=back


=head1 DEPENDENCIES

    PbT
    PbT::GEN::TTQuestion
    PbT::Model::tt_question
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
