package PbT::Test;

use strict;
use Gantry::Utils::CRUDHelp;
use Hash::Merge qw( merge );

use base 'PbT';

use PbT::Model;
use PbT::Model::tt_question qw( $TT_QUESTION );

sub schema_base_class { return 'PbT::Model'; }
use Gantry::Plugins::DBIxClassConn qw( get_schema );

##-----------------------------------------------------------------
## $self->init( $r )
##-----------------------------------------------------------------
sub init {
    my ( $self, $r ) = @_;

    # process SUPER's init code
    $self->SUPER::init( $r );

    $self->auth_deny( 'yes' );

} # END init
 
#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_makeofficial {
     my ( $self, $id ) = @_;

     my $user_id = $self->auth_user_row->id;

     my %param = $self->get_param_hash();        
     my $sch   = $self->get_schema();
     
     my @rm  = $sch->resultset( 'tt_summary' )->search( 
         { user_data => $user_id } 
     );
     my $add  = $sch->resultset( 'tt_summary' )->search( 
         { user_data => $user_id, id => $id } 
     )->next;
     
     foreach my $row ( @rm ) {
        $row->update( { active => 0 } );
     }
    
     $add->update( { active => 1 } );
        
     $self->relocate( $self->app_rootp . "/home" );
     return;
     
}
 
#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_default {
     my ( $self, $q ) = @_;

     my $user_id = $self->auth_user_row->id;
     $self->stash->view->template( 'question.tt' );
    
     my %param = $self->get_param_hash();        
     my $sch   = $self->get_schema();
     
     my $session_id = '';
    
     if ( $param{session_id} eq '' ) {
         $q          = 1;
         $session_id = time . rand( 6 );
     }
     else {
         $session_id = $param{session_id};
     }
            
     my $summary_list = $sch->resultset( 'tt_summary' )->search( 
         { user_data => $user_id }
     );

     my $stored_params = $self->mycache->get( $session_id );
     
     # get the total number of questions
     my $questions = $sch->resultset( 'tt_question' )->search( undef );
     my $total_questions = $questions->count;
     
     if ( $self->is_post() ) {
         
         # merge and store        
         my %new_params;
         if ( $stored_params ) {
             %new_params = %{ merge( $stored_params, \%param ) };
         }
         else {
             %new_params = %param;
         }
         
         $self->mycache->set( $session_id, \%new_params );
          

         # last question
         if ( $q == $total_questions ) {

             my $active = $summary_list->count <= 0 ? 1 : 0;
             
             my $fields = {
                 user_data => $user_id,
                 created   => 'now',
                 active    => $active,
             };

             calculate_personality( $self, $fields, \%new_params );
             
             $sch->resultset( 'tt_summary' )->create( $fields );
             
             $self->relocate( $self->app_rootp . "/home" );
             return;
         }
            
         # increment question number
         $q += 1;

     }

     my $question = $sch->resultset( 'tt_question' )->search( {
         sort_order => $q
     } )->next;        
    
     $self->stash->view->data( { 
         question => $question,
         answers  => $stored_params,
         session_id => $session_id,
         total_questions => $total_questions,
     } );     
     
}

my %cat_labels = (
    'E' => 'extrovert',
    'I' => 'introvert',
    'S' => 'sensing',
    'N' => 'intuitive',
    'T' => 'thinking',
    'F' => 'feeling',
    'J' => 'judging',
    'P' => 'perceiving',
);

my %cat_type = (
    'E' => 'E',
    'I' => 'E',
    'S' => 'S',
    'N' => 'S',
    'T' => 'T',
    'F' => 'T',
    'J' => 'J',
    'P' => 'J',
);

my %cat_negative_type = (
    'E' => 'I',
    'S' => 'N',
    'T' => 'F',
    'J' => 'P',
);

my %cat_tie_goes_to = (
    'E' => 'I',
    'S' => 'S',
    'T' => 'T',
    'J' => 'J',
);

# Note that this method adds elements to $fields hash ref.
sub calculate_personality {
    my $self   = shift;
    my $fields = shift;
    my $param  = shift;

    # pull in all questions and store for later
    my $question_result = $TT_QUESTION->gsearch( $self, undef );
    my %questions;
    while ( my $question = $question_result->next ) {
        $questions{ $question->id } = $question;
    }

    my %differences;
    my %totals = (
        'E' => 0,
        'S' => 0,
        'T' => 0,
        'J' => 0,
    );

    # loop over results and add summary
    PARAM_KEY:
    foreach my $k ( keys %{ $param } ) {
        next PARAM_KEY unless $k =~ /^q(\d+)/;

        my $question_id = $1;
        my $question    = $questions{ $question_id };
        my $answer      = $param->{ $k };

        $totals{ $cat_type{ $answer } }++;

        if ( $answer eq $cat_type{ $answer } ) {
            $differences{ $cat_type{ $answer } }++;
        }
        else {
            $differences{ $cat_type{ $answer } }--;
        }
    }

#    my $reject = 0;
#    foreach my $dimension ( keys %total ) {
#        $reject++ if ( $total{ $dimension } < 5 );
#    }
#
#    # report error: test rejected, not enough questions answered

    my $summary_text  = '';
    my $short_summary = '';

    foreach my $name_of_difference qw( E S T J ) {
        my $category_label = $cat_labels{ $name_of_difference };
        my $difference     = $differences{ $name_of_difference };

        $fields->{ $category_label } = $difference;

        if ( $difference > 0 ) {

            $summary_text  .= "$name_of_difference+$difference";
            $short_summary .= $name_of_difference;

        }
        elsif( $difference == 0 ) { # use default letter

            my $reported_label = $cat_tie_goes_to{ $name_of_difference };

            $summary_text     .= "$reported_label+0";
            $short_summary    .= $reported_label;
        }
        else { # negative, switch letters
            $difference       *= -1;

            my $reported_label = $cat_negative_type{ $name_of_difference };

            $summary_text     .= "$reported_label+$difference";
            $short_summary    .= $reported_label;
        }
    }

    $fields->{ summary_text  } =  $summary_text;
    $fields->{ short_summary } =  $short_summary;
}

1;

=head1 NAME

PbT::Test - A test controller in the PbT application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use PbT::Test;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/test' => 'PbT::Test',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use PbT::Test;
    </Perl>

    <Location /test>
        SetHandler  perl-script
        PerlHandler PbT::Test
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module administers personality profile tests to users upon their
request.  It also supplies the calculation method for the SOAP interface.

=head1 METHODS

=over 4

=item init

=item do_main

=item do_default

=item do_makeofficial

=item calculate_personality

Exposed for SOAP use.  Calculates scores.

=item schema_base_class

=back


=head1 DEPENDENCIES

    PbT
    Gantry::Utils::CRUDHelp

=head1 AUTHOR

Phil Crow, E<lt>phil@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
