use strict;

use Test::More tests => 9;

use PbT qw{ -Engine=CGI -TemplateEngine=TT };

use Gantry::Server;
use Gantry::Engine::CGI;

# these tests must contain valid template paths to the core gantry templates
# and any application specific templates

my $cgi = Gantry::Engine::CGI->new( {
    config => {
        dbconn => 'dbi:SQLite:dbname=app.db',
        auth_table => 'user_data',
        auth_user_field => 'user_name',
        dbuser => 'postgres',
        doc_rootp => '/static',
        root => '/home/httpd/html/PbT/templates',
        temp_image_dir => '/tmp/images',
        template_wrapper => 'genwrapper.tt',
    },
    locations => {
        '/' => 'PbT',
        '/user' => 'PbT::UserData',
        '/like' => 'PbT::LikeData',
        '/tt_question' => 'PbT::TTQuestion',
        '/tt_answer' => 'PbT::TTAnswer',
        '/tt_summary' => 'PbT::TTSummary',
        '/enne' => 'PbT::Enne',
        '/visible' => 'PbT::Visible',
        '/country' => 'PbT::Country',
    },
} );

my @tests = qw(
    /
    /user
    /like
    /tt_question
    /tt_answer
    /tt_summary
    /enne
    /visible
    /country
);

my $server = Gantry::Server->new();
$server->set_engine_object( $cgi );

SKIP: {

    eval {
        require DBD::SQLite;
    };
    skip 'DBD::SQLite is required for run tests.', 9 if ( $@ );

    unless ( -f 'app.db' ) {
        skip 'app.db sqlite database required for run tests.', 9;
    }

    foreach my $location ( @tests ) {
        my( $status, $page ) = $server->handle_request_test( $location );
        ok( $status eq '200',
                "expected 200, received $status for $location" );

        if ( $status ne '200' ) {
            print STDERR $page . "\n\n";
        }
    }

}
