<?php

/**
 * Login controller includes methods for user authentification
 *
 */
class AuthController extends IndexController
{
    protected $_blIsFullyCached    = false;

    public function indexAction()
    {
        //performing login and adding cookie on success
        $oUser = & pfUtils::pfNew('pfUser');
        $sLogin = pfInput::getInstance( pfInput::PFINPUT_POST)->getValue( 'sLogin');
        $sPassword = pfInput::getInstance( pfInput::PFINPUT_POST)->getValue( 'sPassword');

//        echo $sLogin . ' <> ' . $sPassword;
//        die();
        if (!$oUser->loadByPassword( $sLogin, $sPassword)) {
            $this->_oSmartyView->assign('sError', 'Invalid login');
            $this->output();
            return;
        }
        else {
            //successful login
            $sId = $oUser->sId;
            Zend::Registry('session')->sUsrId = $sId;

            // update last login time
            $oUser->assign( array( 'last_login' => date('Y-m-d H:i:s', time())));
            $oUser->save();
        }

        $this->redirectWithSid('/index/index/');
    }

    public function logoutAction()
    {
        $this->_oSmartyView->assign('oAuth', null);
        $this->_oSmartyView->render( $this->_sTemplateFile);

        Zend_Session_Core::destroy(true);

        $this->redirectWithSid( '/index/index/');
    }


}