<?php

/**
 * ControllerBase instance acts as
 *
 */
class ControllerBase extends Zend_Controller_Action
{
    /**
     * Reference to smarty view wrapper
     *
     * @var OXID_View_Smarty
     */
    protected $_oSmartyView     = null;

    /**
     * Associated template name
     *
     * @var string
     */
    protected $_sTemplateFile   = null;

    /**
     * if this value is true this controller can only be called if the user is authed
     *
     * @var boolean
     */
    protected $_onlyAuthed = true;

    /**
     * array
     *
     * @var array
     */
    protected $_onlyAuthedSkipAction = array();

    /**
     * Inits object and assign
     *
     */
	final public function __construct(Zend_Controller_Request_Abstract $request, Zend_Controller_Response_Abstract $response, array $invokeArgs = array())
    {
        // Get Smarty View
        $this->_oSmartyView = Zend::registry('smarty_view');

        //Session handling
        if ( true === pfInput::isCookieDisabled()) {
            $sPF = $request->getParam('pf');
            if( null !== $sPF ) {
                session_id(Zend_Filter::getAlnum($sPF));
            }
        }

        // session
        Zend_Session_Core::setOptions(array( 'name' => 'pf',
                                             'use_only_cookies' => false
                                             ));

        $oSession = new Zend_Session('pfSession');
        Zend::register('session', $oSession);
        if (!isset($oSession->bInitialized)) {
            Zend_Session_Core::regenerateId();
            $oSession->bInitialized = true;
        }
        $oSession->setExpirationSeconds( 3600);

        $sSessUsrId = $oSession->sUsrId;

        // set by hand disabled parent constructor
        $this->setRequest($request)
             ->setResponse($response)
             ->_setInvokeArgs($invokeArgs);

        $sActionName = $request->getActionName();
        if ($this->_onlyAuthed && !$sSessUsrId && !in_array($sActionName, $this->_onlyAuthedSkipAction)) {
            $this->redirectwithsid('/index/index/');
            exit;
        }

        if (true === pfInput::isCookieDisabled()) {
            $sSessionLink = session_name() . '/' . Zend_Session_Core::getId();
            $sSessionID = Zend_Session_Core::getId();
            $sSessionForm = '<input type="hidden" name="' . session_name() . '" value="' . Zend_Session_Core::getId() . '">';
            $sIndexLink = 'index/';
        } else {
            $sSessionLink = '';
            $sSessionID = '';
            $sSessionForm = '';
            $sIndexLink = '';
        }

        // pass session values
        $this->_oSmartyView->assign( 'sessionlink', $sSessionLink);
        $this->_oSmartyView->assign( 'sessionid',   $sSessionID);
        $this->_oSmartyView->assign( 'sessionform', $sSessionForm);
        $this->_oSmartyView->assign( 'sessionindex', $sIndexLink);
        $this->_oSmartyView->assign( 'config', Zend::registry('config'));
        $this->_oSmartyView->assign( 'controller', $request->getControllerName());
        $this->_oSmartyView->assign( 'action', $sActionName);

        if( $sSessUsrId) {
            $oUser = & pfUtils::pfNew('pfUser');
            if ($oUser->load( $sSessUsrId)) {
                $this->_oSmartyView->assign('oAuth', $oUser);
            }
        }

        // call init procedure
        $this->init();
        //parent constructor
        // DISABLED !!! parent::__construct( $request, $response, $invokeArgs);
    }

    /**
     * Output template, check if we store into cache
     *
     */
    final public function output()
    {
        $sContent = $this->_oSmartyView->fetch( $this->_sTemplateFile);
        echo( $sContent);
    }

    /**
     * Default action. Renders assigned template
     *
     */
    public function indexAction()
    {
        $this->output();
    }

    /**
     * Calls default action
     *
     */
    public function norouteAction()
    {
		$sBaseURI = pfUtils::getRewriteBase();
		if (empty($sBaseURI)) {
			$sBaseURI = '/';
		}

		$this->redirectWithSid( $sBaseURI);
    }

    /**
     * checks if cookies are disabled and add it to path
     *
     * @param string $sPath
     */
    public function redirectWithSid( $sPath)
    {
        $sPath = rtrim($sPath, '/');

        if( pfInput::isCookieDisabled()) {
            $sPath .= "/pf/".Zend_Session_Core::getId();
        }
        $this->_redirect( $sPath);
    }
}