<?php

class PlotController extends ControllerBase
{
    /**
     * skip auth
     *
     * @var boolean
     */
    protected $_onlyAuthed = true;

    /**
     * image resource
     */
    protected $_rImage = null;

    protected $_x = 500;
    protected $_y = 500;

    /**
     * Init Controller, set Templatefile
     *
     */
    public function Init()
    {
        $this->_rImage = imagecreate($this->_x, $this->_y);
    }

    /**
     * sents the png image header
     *
     */
    private function sendHeader()
    {
        header('Content-type: ' . image_type_to_mime_type(IMAGETYPE_PNG));
    }

    /**
     * allocate the given color array rgb
     *
     * @param array $color
     */
    private function allocateColor($color = array())
    {
        $red = (array_key_exists('red', $color)) ? abs((INT)$color['red']) : 0;
        $green = (array_key_exists('green', $color)) ? abs((INT)$color['green']) : 0;
        $blue = (array_key_exists('blue', $color)) ? abs((INT)$color['blue']) : 0;

        return imagecolorallocate($this->_rImage, $red, $green, $blue);
    }

    /**
     * draw an border with the given color
     *
     * @param resource $color
     */
    private function drawBorder($color)
    {
        imagerectangle($this->_rImage, 0, 0, $this->_x-1, $this->_y-1, $color);
    }

    /**
     * plots the image
     *
     */
    public function plotAction()
    {
//          $bg = imagecolorallocate($this->_rImage, 0,0,0);
        $white = $this->allocateColor(array('red' => 255, 'green' => 255, 'blue' => 255)); //white
        $black = $this->allocateColor(); //black
        $red = $this->allocateColor(array('red' => 255, 'green' => 0, 'blue' => 0)); //red

        //draw coords
        $padding = 60;
        imagerectangle($this->_rImage, $padding, $padding, $this->_x - $padding, $this->_y - $padding, $black);

        $length = 50;
        $spacing = 80;

        //xaxis
        $middle = $this->_x / 2;
        imageline($this->_rImage, $middle, $this->_y - $padding, $middle, $this->_y - $length, $black);
        imageline($this->_rImage, $middle - $spacing, $this->_y - $padding, $middle - $spacing, $this->_y - $length, $black);
        imageline($this->_rImage, $middle - $spacing*2, $this->_y - $padding, $middle - $spacing*2, $this->_y - $length, $black);
        imageline($this->_rImage, $middle + $spacing, $this->_y - $padding, $middle + $spacing, $this->_y - $length, $black);
        imageline($this->_rImage, $middle + $spacing*2, $this->_y - $padding, $middle + $spacing*2, $this->_y - $length, $black);

        //yaxis
        $middle = $this->_y / 2;
        imageline($this->_rImage, $padding, $middle, $length, $middle, $black);
        imageline($this->_rImage, $padding, $middle - $spacing, $length, $middle - $spacing, $black);
        imageline($this->_rImage, $padding, $middle - $spacing*2, $length, $middle - $spacing*2, $black);
        imageline($this->_rImage, $padding, $middle + $spacing, $length, $middle + $spacing, $black);
        imageline($this->_rImage, $padding, $middle + $spacing*2, $length, $middle + $spacing*2, $black);
//        imageline($this->_rImage, $middle - $spacing, $this->_y - $padding, $middle - $spacing, $this->_y - $length, $black);
//        imageline($this->_rImage, $middle - $spacing*2, $this->_y - $padding, $middle - $spacing*2, $this->_y - $length, $black);
//        imageline($this->_rImage, $middle + $spacing, $this->_y - $padding, $middle + $spacing, $this->_y - $length, $black);
//        imageline($this->_rImage, $middle + $spacing*2, $this->_y - $padding, $middle + $spacing*2, $this->_y - $length, $black);

//        imageline($this->_rImage, 50, 50, 50, $this->_y-50, $black);
//        imageline($this->_rImage, 10, -10, 100, -100, $red);
        $this->drawBorder($black);

        /**
         * TODO: not done yet
         */
        imagestring($this->_rImage, 4, 10, 10, '!!! NOT DONE YET !!!', $red);

        $this->sendHeader();
        imagepng($this->_rImage);
        imagedestroy($this->_rImage);
    }
}

