<?php

class SearchController extends ControllerBase
{
    /**
     * skip auth
     *
     * @var boolean
     */
    protected $_onlyAuthed = true;

    /**
     * Init Controller, set Templatefile
     *
     */
    public function Init()
    {
        $this->_sTemplateFile = 'search.tpl';
        $this->_oSmartyView->assign('aTTTTypes', pfUtils::getTTTTypes());
    }

    public function adduserAction()
    {
        $iAddUserID = pfInput::getInstance( pfInput::PFINPUT_GET )->getValue( 'id');
        $sStatus = pfInput::getInstance( pfInput::PFINPUT_GET )->getValue( 'status');

        $oSession = Zend::registry('session');
        $oUser = pfUtils::pfNew( 'pfUser');
        $oUser->Load( $oSession->sUsrId);
        $oUser->ChangeStatus( $iAddUserID, strtoupper( $sStatus));

        return $this->searchAction();
    }

    /**
     * default index
     *
     */
    public function indexAction()
    {
        $this->output();
    }

    public function searchAction()
    {
        $aSearchThis = pfInput::getInstance( pfInput::PFINPUT_ALL)->getValue('search');

        // validate input
        if( isset( $aSearchThis['no_contacts']))
            $aSearchThis['no_contacts'] = (bool)Zend_Filter::getDigits( $aSearchThis['no_contacts']);
        if( isset( $aSearchThis['no_rcd']))
            $aSearchThis['no_rcd'] = (bool)Zend_Filter::getDigits( $aSearchThis['no_rcd']);
        if( isset( $aSearchThis['since_logout'] ))
            $aSearchThis['since_logout'] = (bool)Zend_Filter::getDigits( $aSearchThis['since_logout']);
        if( isset( $aSearchThis['since_days'])) {
            $aSearchThis['since_days'] = Zend_Filter::getInt( $aSearchThis['since_days']);
            if( !in_array( $aSearchThis['since_days'], array( -1, 1, 3, 7, 14, 30, 60, 90)))
                $aSearchThis['since_days'] = -1;
        }
        if( isset( $aSearchThis['since_logoutttt']))
            $aSearchThis['since_logoutttt'] = (bool)Zend_Filter::getDigits( $aSearchThis['since_logoutttt']);
        if( isset( $aSearchThis['since_daysttt'])) {
            $aSearchThis['since_daysttt']   = Zend_Filter::getInt( $aSearchThis['since_daysttt']);
            if( !in_array( $aSearchThis['since_daysttt'], array( -1, 1, 3, 7, 14, 30, 60, 90)))
                $aSearchThis['since_daysttt'] = -1;
        }
        if( isset( $aSearchThis['mycountry']))
            $aSearchThis['mycountry']       = (bool)Zend_Filter::getDigits( $aSearchThis['mycountry']);
        if( isset( $aSearchThis['around_kilometers'])) {
            $aSearchThis['around_kilometers'] = Zend_Filter::getInt( $aSearchThis['around_kilometers']);
            if( !in_array( $aSearchThis['around_kilometers'], array( -1, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000)))
                $aSearchThis['around_kilometers'] = -1;
        }
        if( isset( $aSearchThis['motto_contains']))
            $aSearchThis['motto_contains']  = strip_tags( htmlentities( trim( Zend_Filter::getAlpha( $aSearchThis['motto_contains']))));
        if( isset( $aSearchThis['match_ttt']) && is_array($aSearchThis['match_ttt'])) {
            $aTmp = array();
            foreach (pfUtils::getTTTTypes() as $k => $v) {
                if (in_array($v, $aSearchThis['match_ttt'])) {
                    $aTmp[] = $v;
                }
            }
            $aSearchThis['match_ttt'] = $aTmp;
        }
        else {
            $aSearchThis['match_ttt'] = array();
        }
        if( isset( $aSearchThis['same_enna']))
            $aSearchThis['same_enna'] = (bool)Zend_Filter::getDigits( $aSearchThis['same_enna']);
        if( isset( $aSearchThis['onesame_enna']))
            $aSearchThis['onesame_enna'] = (bool)Zend_Filter::getDigits( $aSearchThis['onesame_enna']);
        if( isset( $aSearchThis['related_enna']))
            $aSearchThis['related_enna'] = (bool)Zend_Filter::getDigits( $aSearchThis['related_enna']);

        $oSession = Zend::registry('session');

        // Query now
        $iPage = pfInput::getInstance( pfInput::PFINPUT_GET )->getValue( 'pg');
        if( !isset( $iPage))
            $iPage = 0;

        $this->_oSmartyView->assign('aSearchThis', $aSearchThis);

        $oRet = pfQuery::getInstance()->Query( $aSearchThis, $oSession->sUsrId, $iPage, 10);
        $this->_oSmartyView->assign('getsearch', $oRet->getsearch);
        if( count( $oRet->aRows)) {

            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);

            $this->_oSmartyView->assign('aSearchResults', $aRows);
            if( isset( $oRet->pagenavigation))
                $this->_oSmartyView->assign('pageNavigation', $oRet->pagenavigation);
        }
        else
            $this->_oSmartyView->assign('blNoSearchResults', true);

        $this->output();
    }
}

