<?php

class StatusController extends ControllerBase
{
    /**
     * Init Controller, set Templatefile
     *
     */
    public function Init()
    {
        $this->_sTemplateFile = 'status.tpl';
    }

    public function indexAction()
    {
        //loadding user
        $oSession = Zend::registry('session');
        $sUserId = $oSession->sUsrId;
        $oUser = & pfUtils::pfNew('pfUser');

        //could be that we asked to load another users
        $sGetUser = Zend_Filter::getInt($this->getRequest()->getParam('userid'));

        if ($sGetUser)
            $sUserId = $sGetUser;

        $oUser->load($sUserId);

        $this->_oSmartyView->assign('oUser', $oUser);

        //loading user lists
        $oRet = pfQuery::getInstance()->Query( array( 'only_acc' => 1), $sUserId, 0, 0);
        if( count( $oRet->aRows)) {
            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);
            $this->_oSmartyView->assign('aMembersInContact', $aRows);
        }

        $oRet = pfQuery::getInstance()->Query( array( 'only_rcd_sent' => 1), $sUserId, 0, 0);
        if( count( $oRet->aRows)) {
            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);
            $this->_oSmartyView->assign('aMembersRcdSent', $aRows);
        }


        $oRet = pfQuery::getInstance()->Query( array( 'only_rcd' => 1), $sUserId, 0, 0);
        if( count( $oRet->aRows)) {
            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);
            $this->_oSmartyView->assign('aMembersRcdReceived', $aRows);
        }

        $this->output();
    }

}

