<?php

class TttController extends ControllerBase
{
    private $_aQuestions = array(
                            1 => array('The whole is more than the sum of its parts',
                                    array(
                                        's' => 'is a saying that I never found very convincing',
                                        'n' => 'is a very important observation'
                                     ),
                                ),
                            2 => array('A small project',
                                    array(
                                        'j' => 'should be planned as well as a big one',
                                        'p' => 'allows to jump right in',
                                        ),
                                ),
                            3 => array('Abstract art',
                                    array(
                                        's' => 'tends to annoy me',
                                        'n' => 'is often very interesting',
                                        ),
                                ),
                            4 => array('Arguments should be won',
                                    array(
                                        't' => 'by the person with the better arguments',
                                        'f' => 'by the person fighting for the better cause',
                                        ),
                                ),
                            5 => array('Games that have no winner',
                                    array(
                                        'j' => 'I usually do not like',
                                        'p' => 'can be fun',
                                        ),
                                ),
                            6 => array('Going to the movies alone is',
                                    array(
                                        'e' => 'horrible',
                                        'i' => 'OK',
                                        ),
                                ),
                            7 => array('Helpless people',
                                    array(
                                        't' => 'should be taught to help themselves',
                                        'f' => 'need help NOW',
                                        ),
                                ),
                            8 => array('I enjoy a walk most',
                                    array(
                                        'e' => 'together with a good friend',
                                        'i' => 'in the peace and quiet of nature',
                                        ),
                                ),
                            9 => array('I like teamwork best',
                                    array(
                                        'e' => 'in the beginning when work has to be talked over',
                                        'i' => 'in those times when I know what to do and can do it alone',
                                        ),
                                ),
                            10 => array('I often find emotional people',
                                    array(
                                        't' => 'irritating',
                                        'f' => 'likable',
                                        ),
                                ),
                            11 => array('I prefer taxi drivers that',
                                    array(
                                        'e' => 'talk to me',
                                        'i' => 'drive silently',
                                        ),
                                ),
                            12 => array('I prefer to',
                                    array(
                                        'j' => 'plan my day even if it is difficult to foresee',
                                        'p' => 'wait and see',
                                        ),
                                ),
                            13 => array('I prefer',
                                    array(
                                        'i' => 'reading',
                                        'e' => 'games with others',
                                        ),
                                ),
                            14 => array('I respect people most for',
                                    array(
                                        't' => 'what they achieve',
                                        'f' => 'the attitudes they have',
                                        ),
                                 ),
                            15 => array('I tend to believe claims',
                                    array(
                                        'n' => 'when they are plausible to me',
                                        's' => 'when I have concrete information that supports them',
                                        ),
                                 ),
                            16 => array('I\'d rather',
                                    array(
                                        'f' => 'fail than doing something wrong',
                                        't' => 'bend a rule a little than fail',
                                        ),
                                 ),
                            17 => array('If I were a super-popular star, I\'d rather be',
                                    array(
                                        'e' => 'an actor',
                                        'i' => 'an author',
                                        ),
                                 ),
                            18 => array('If a project gets behind schedule',
                                    array(
                                        'p' => 'one should adapt the schedule accordingly',
                                        'j' => 'it should make an effort to get back on schedule',
                                        ),
                                 ),
                            19 => array('If two employees are having an argument, an ideal boss would',
                                    array(
                                        'p' => 'often let them solve it alone',
                                        'j' => 'usually step in and sort it out',
                                        ),
                                 ),
                            20 => array('In my spare time',
                                    array(
                                        'e' => 'I like to be with people',
                                        'i' => 'I often prefer to be alone',
                                        ),
                                 ),
                            21 => array('Laying off employees is',
                                    array(
                                        'f' => 'sad',
                                        't' => 'sometimes necessary',
                                        ),
                                 ),
                            22 => array('Making decisions',
                                    array(
                                        'p' => 'tends to be hard',
                                        'j' => 'tends to be easy',
                                        ),
                                 ),
                            23 => array('On parties',
                                    array(
                                        'i' => 'I often stand alone',
                                        'e' => 'I tend to be in a crowd',
                                        ),
                                 ),
                            24 => array('Rules are',
                                    array(
                                        'j' => 'generally helpful',
                                        'p' => 'often annoying',
                                        ),
                                 ),
                            25 => array('Skilled rhetoric is',
                                    array(
                                        'f' => 'often a way of manipulating people',
                                        't' => 'a tool for expressing oneself clearly and convincingly',
                                        ),
                                 ),
                            26 => array('The reasons for doing something should be',
                                    array(
                                        'f' => 'morally valuable',
                                        't' => 'logical and pragmatic',
                                        ),
                                 ),
                            27 => array('To be a judge in an literature competition',
                                    array(
                                        'p' => 'I would tend to find straining and unsatisfying',
                                        'j' => 'I would find an interesting task',
                                        ),
                                 ),
                            28 => array('To decide if a work of art is good',
                                    array(
                                        's' => 'I need to know what are important aspects for this kind of art',
                                        'n' => 'I just see whether it appeals to me',
                                        ),
                                 ),
                            29 => array('To understand the situation of a group of people, I rather rely on',
                                    array(
                                        'n' => 'descriptions of typical cases',
                                        's' => 'survey results',
                                        ),
                                 ),
                            30 => array('Usability tests are important because',
                                    array(
                                        'f' => 'low usability is bad for people',
                                        't' => 'otherwise few people will use the product later',
                                        ),
                                 ),
                            31 => array('What I enjoy most when I go to a conference is',
                                    array(
                                        'i' => 'the talks',
                                        'e' => 'the talking',
                                        ),
                                 ),
                            32 => array('When 85-year-olds get an artificial hip that is',
                                    array(
                                        'f' => 'a wonderful victory of medicine over nature',
                                        't' => 'a use of resources that ought to be weighed against alternatives',
                                        ),
                                 ),
                            33 => array('When I create something',
                                    array(
                                        's' => 'I tend to put together elements of existing things',
                                        'n' => 'I create it anew as a whole',
                                        ),
                                 ),
                            34 => array('When I had a disappointment',
                                    array(
                                        'e' => 'I like it when friends help me get over it',
                                        'i' => 'I get over it best all by myself',
                                        ),
                                 ),
                            35 => array('When I prepare a decision',
                                    array(
                                        's' => 'I gather as much concrete information as I can',
                                        'n' => 'I also trust my intuition',
                                        ),
                                 ),
                            36 => array('When I view a sports match of two foreign national teams',
                                    array(
                                        'p' => 'I often remain neutral',
                                        'j' => 'I prefer taking sides for one of them',
                                        ),
                                 ),
                            37 => array('When a company rule appears not to fit a situation',
                                    array(
                                        'j' => 'I usually stick to it anyway. That is what rules are for.',
                                        'p' => 'I wonder whether I should make an exceptionp',
                                        ),
                                 ),
                            38 => array('When asked to comment on a complex plan or idea',
                                    array(
                                        's' => 'I look for details that may be wrong',
                                        'n' => 'I tend to answer on a hunch',
                                        ),
                                ),
                            39 => array('When confronted with a new software application',
                                    array(
                                        'n' => 'I like to understand its basic concepts first',
                                        's' => 'I prefer delving in and doing concrete things with it',
                                        ),
                                ),
                            40 => array('When confronted with a sketch of a great design of a building or machine',
                                    array(
                                        'n' => 'I am impressed and inspired',
                                        's' => 'I\'d rather see the final product',
                                        ),
                                ),
                         );

    /**
     * question count
     *
     * @var int
     */
    private $_iQuestionCount = 0;

    /**
     * current question id
     *
     * @var int
     */
    private $_iQuestion = 1;

    /**
     * result
     */
    private $_aQuestResult = false;

    /**
     * keirsey names
     *
     * @var array
     */
    private $_aKeirseyNames = array(
                                'sj' => array('sj', 'Guardian'),
                                'sp' => array('sp', 'Artisan'),
                                'nt' => array('nt', 'Rational'),
                                'nf' => array('nf', 'Idealist'),
                                );

    /**
     * Init Controller, set Templatefile
     *
     */
    public function Init()
    {
        $this->_sTemplateFile = 'ttt.tpl';
        $this->_iQuestionCount = count($this->_aQuestions);
        $this->_iQuestion = Zend_Filter::getInt($this->getRequest()->getParam('q'));
        $this->_boundingCheck();
        $this->_loadUserQuestions();
    }

    /**
     * loads the user default session values
     *
     */
    private function _loadUserQuestions()
    {
        $oSession = Zend::registry('session');
        if ($oSession->sUsrId)
        {
            $oUser = pfUtils::pfNew('pfUser');
            $oUser->load($oSession->sUsrId);
            $sAnswers = $oUser->aFields['ttt_answers']->sValue;
            $iOld = $this->_iQuestion;
            for ($x=0; $x<$this->_iQuestionCount; $x++) {
                $this->_iQuestion = $x+1;
                $this->_getQuestionSessionValue();
                if (isset($sAnswers[$x]) && $sAnswers[$x] != ' ') {
                    $this->_setQuestionSessionValue($sAnswers[$x]);
                }
            }
            $this->_iQuestion = $iOld;

            if ($oUser->aFields['ttt']->sValue != '') {
                $sKeirsey = $oUser->aFields['ttt']->sValue;

                if (ereg('s[tf]+j', $sKeirsey, $reg)) {
                    $aKeirsey = $this->_aKeirseyNames['sj'];
                } elseif (ereg('s[tf]+p', $sKeirsey, $reg)) {
                    $aKeirsey = $this->_aKeirseyNames['sp'];
                } elseif (ereg('nt', $sKeirsey, $reg)) {
                    $aKeirsey = $this->_aKeirseyNames['nt'];
                } elseif (ereg('nf', $sKeirsey, $reg)) {
                    $aKeirsey = $this->_aKeirseyNames['nf'];
                }

                $this->_aQuestResult = array(
                                            'ttt' => $oUser->aFields['ttt']->sValue,
                                            'ttt_full' => $oUser->aFields['ttt_full']->sValue,
                                            'keirsey' => $aKeirsey,
                                            );
            }

            $this->_oSmartyView->assign('aQuestResult', $this->_aQuestResult);
        }
    }

    /**
     * checks bounds and set defaults
     *
     */
    private function _boundingCheck()
    {
        // bouncing checks
        $this->_iQuestion = ($this->_iQuestion > $this->_iQuestionCount) ? 40 : $this->_iQuestion;
        $this->_iQuestion = ($this->_iQuestion <= 0) ? 1 : $this->_iQuestion;
    }

    /**
     * sets the question session value
     *
     * returns false if not valid value
     * @return boolean
     */
    private function _setQuestionSessionValue($sAnswer)
    {
        if (array_key_exists($sAnswer, $this->_aQuestions[$this->_iQuestion][1])) {
            $oSession = Zend::registry('session');
            $this->_getQuestionSessionValue();
            $aOrg = $oSession->aQuestionValue;

            // write session value back
            $aOrg[$this->_iQuestion] = $sAnswer;
            $oSession->aQuestionValue = $aOrg;
            return true;
        }

        return false;
    }

    /**
     * returns the TTT String
     *
     * @return string
     */
    private function _getTTTString()
    {
        $sRet = '';
        foreach ($this->_getAllQuestionSessionValues() as $k => $v) {
            $sRet .= (false === $v) ? ' ' : $v;
        }
        return $sRet;
    }

    /**
     * returns all session values for the questions
     *
     * @return array
     */
    private function _getAllQuestionSessionValues()
    {
        $aQuestionValue = array();
        $i = $this->_iQuestion;
        for ($x = 1; $x<=$this->_iQuestionCount; $x++) {
            $this->_iQuestion = $x;
            $aQuestionValue[$x] = $this->_getQuestionSessionValue();
        }
        $this->_iQuestion = $i;
        return $aQuestionValue;
    }

    /**
     * returns the question session value
     *
     * @return array
     */
    private function _getQuestionSessionValue()
    {
        $oSession = Zend::registry('session');

        $aQuestionValue = (array)$oSession->aQuestionValue;
        if (null !== $aQuestionValue && is_array($aQuestionValue)) {
            if (!array_key_exists($this->_iQuestion, $aQuestionValue)) {
                $aQuestionValue[$this->_iQuestion] = false;
                $oSession->aQuestionValue = $aQuestionValue;
            }
        } else {
            $oSession->aQuestionValue = array();
        }

        return $aQuestionValue[$this->_iQuestion];
    }

    public function SaveAction()
    {
        $sAnswer = pfInput::getInstance(pfInput::PFINPUT_POST)->getValue('answer');
        if (null !== $sAnswer) {
            $sAnswer = strtolower($sAnswer);
            if (!$this->_setQuestionSessionValue($sAnswer)) {
                $this->indexAction();
                return;
            } else {
                $ttt_string = $this->_getTTTString();
                try {
                    pfCore::getInstance()->SetSessionMode(false);
                    pfCore::getInstance()->TakeTTT( Zend_Session_Core::getId(), $ttt_string);
                } catch (Exception $e) {
                    $oSession = Zend::registry('session');
                    $oUser = pfUtils::pfNew('pfUser');
                    $oUser->load($oSession->sUsrId);
                    $oUser->assign(array('ttt_answers' => $ttt_string,
                                         'ttt_testtime' => date('Y-m-d H:i:s')), false);
                    $oUser->save();
                }
            }
        }

        if (null !== pfInput::getInstance(pfInput::PFINPUT_POST)->getValue('next')) {
            $this->_iQuestion++;
        } elseif (null !== pfInput::getInstance(pfInput::PFINPUT_POST)->getValue('back')) {
            $this->_iQuestion--;
        }
        $this->_boundingCheck();

        $this->redirectWithSid('ttt/index/q/' . $this->_iQuestion);
    }

    public function IndexAction()
    {
        /**
         * fetch question id and set default 1 if none entered or an invalid question id
         */
        $sQuestionValue = $this->_getQuestionSessionValue();

        if ($this->_iQuestion > 0 && $this->_iQuestion <= $this->_iQuestionCount) {
            if (array_key_exists($this->_iQuestion, $this->_aQuestions)) {
                $this->_oSmartyView->assign('aQuestion', $this->_aQuestions[$this->_iQuestion]);
            }
            $this->_oSmartyView->assign('sQuestionValue', $sQuestionValue);
        }
        $this->_oSmartyView->assign('iQuestionCount', $this->_iQuestionCount);
        $this->_oSmartyView->assign('iQuestionCurrent', $this->_iQuestion);
        $this->_oSmartyView->assign('aQuestionAllValues', $this->_getAllQuestionSessionValues());

        //new registration notification
        if ($this->getRequest()->getParam('new') == 'registration')
            $this->_oSmartyView->assign('sMessage', 'Thank you for your registration! Now, in order to finalize your profile setup, please complete TTT test.');

        $this->output();
    }

}

