<?php

class UserController extends ControllerBase
{

    /**
     * skip auth
     *
     * @var boolean
     */
    protected $_onlyAuthed = false;

    /**
     * Init Controller, set Templatefile
     *
     */
    public function Init()
    {
        $this->_sTemplateFile = 'user.tpl';
    }

    public function indexAction()
    {
        $oSession = Zend::registry('session');
        $oUser = &pfUtils::pfNew('pfUser');
        if ($oSession->sUsrId)
        {
            $oUser->load($oSession->sUsrId);
            $this->_oSmartyView->assign('oUser', $oUser);
        }

        return parent::indexAction();
    }

    /**
     * Initalises user info update (or insert)
     * On exception disaplys error message.
     * On success updates authorised user info (i.e. automatically logs new user in)
     *
     */
    public function saveAction()
    {
        $aParams = pfInput::getInstance(pfInput::PFINPUT_POST)->getValue('edit');

        $oSession = Zend::registry('session');
        $oUser = &pfUtils::pfNew('pfUser');
        $sId = '';

        try {

            //checking id from session
            if ($oSession->sUsrId)
                $oUser->sId = $oSession->sUsrId;

            //saving user info
            $oUser->assign($aParams);
            $sId = $oUser->save();
            $this->_oSmartyView->assign('oAuth', $oUser);

            $oSession = Zend::registry('session');
            $sRedirectLink = '/user/index/';
            if ($sId && !$oSession->sUsrId)
                //new user registration
                $sRedirectLink = "/ttt/index/new/registration/";
            if ($sId)
                $oSession->sUsrId = $sId;
            $this->redirectWithSid($sRedirectLink);
            return;

        }
        catch (Exception $eError)
        {
            $this->_oSmartyView->assign('sError', $eError->getMessage());
        }

        $this->_oSmartyView->assign('oUser', $oUser);
        $this->output();
    }

}