<?php


// Complex Types used in SOAP call
class Memberinfo
{
    public $country             = '';
    public $dislikes            = '';
    public $emailAddress        = '';
    public $enneagramtype1      = '';
    public $enneagramtype2      = '';
    public $fullname            = '';
    public $gpsCoordinates      = '';
    public $likes               = '';
    public $motto1              = '';
    public $motto2              = '';
    public $registrationTime    = '';
    public $town                = '';
    public $tttTestTime         = '';
    public $tttType             = '';
    public $username            = '';
}

/**
 * All functionality is stored here, functions are named exact like in SOAP calls required
 *
 */
class pfCore {

    static $_oInstance = null;

    /**
     * if set, we use our own session
     *
     * @var boolean
     */
    private $_blUseInternalSession = true;

    // inline
    public function SetSessionMode( $blUseInteralSession)     { $this->_blUseInternalSession = $blUseInteralSession;    }

    /**
     * singelton
     *
     * @return pfCore
     */
    static public function getInstance()
    {
        if( !isset( self::$_oInstance))
            self::$_oInstance = new pfCore( );

        return self::$_oInstance;
    }

    private function __construct()
    {

    }

    /**
     * checks if this session is valid
     *
     * @param string $sSessionID
     * @return Zend_Session
     */
    private function _getSession( $sSessionID)
    {
        if( $this->_blUseInternalSession) {
            $name       = 'pfsoap';
            $namespace  = 'pfSOAPSession';
        }
        else {
            $name       = 'pf';
            $namespace  = 'pfSession';
        }

        // session
        session_id( Zend_Filter::getAlnum( $sSessionID));
        Zend_Session_Core::setOptions(array( 'name' => $name,
                                             'use_only_cookies' => false
                                             ));
        $oSession = new Zend_Session( $namespace);
        if (!isset($oSession->bInitialized) || !$oSession->sUsrId) {
            throw new Exception( 'invalid session id');
        }
        else
            return $oSession;
    }


    /**
     * login user as specified in req.spec. page 14
     *
     * @param string $sUserName
     * @param string $sPassword
     * @return string
     */
    public function login( $sUserName, $sPassword)
    {
        $sSessionID = null;

        $oUser = pfUtils::pfNew( 'pfUser');
        if( $oUser->loadByPassword( $sUserName, $sPassword)) {
            // success

            if( $this->_blUseInternalSession) {
                $name       = 'pfsoap';
                $namespace  = 'pfSOAPSession';
            }
            else {
                $name       = 'pf';
                $namespace  = 'pfSession';
            }

            Zend_Session_Core::setOptions(array( 'name' => $name,
                                                 'use_only_cookies' => false
                                                 ));

            $oSession = new Zend_Session( $namespace);
            Zend::register('soapsession', $oSession);
            if (!$oSession->bInitialized) {
                Zend_Session_Core::regenerateId();
                $oSession->bInitialized = true;
            }
            $oSession->setExpirationSeconds( 3600);

            // store user id
            $oSession->sUsrId = $oUser->sId;

            $sSessionID = Zend_Session_Core::getId();
        }

        return $sSessionID;
    }

    /**
     * destroy session as specified in req.spec. page 14
     *
     * @param unknown_type $sSessionID
     */
    public function logout( $sSessionID)
    {
        $oSession = $oSession = $this->_getSession( $sSessionID);
        Zend_Session_Core::destroy();
    }

    /**
     * clears database as specified in req.spec. page 14
     *
     */
    public function clearDatabase()
    {
        $oDB = pfDB::getDB();

        $oDB->query('delete from pfusers');
        $oDB->query('delete from pfrelations');
        $oDB->query('delete from pflikes');
    }

    /**
     * Updates or Inserts a new User Object  as specified in req.spec. page 14
     *
     * @param string $sSessionID
     * @param array $aFields
     */
    public function submitMemberInfo( $sSessionID, $aFields)
    {
        $oUser = & pfUtils::pfNew( 'pfUser');

        if( $sSessionID) {
            // if there is a session ID, then username must be empty
            if( isset( $aFields['login']) && $aFields['login'])
                throw new Exception( 'You provided Username with Session - Thats invalid');
            // session
            $oSession = $oSession = $this->_getSession( $sSessionID);
            if( !$oUser->Load( $oSession->sUsrId)) {
                throw new Exception( 'User not found!');
            }
        }

        $oUser->assign( $aFields);
        $oUser->Save();
    }

    /**
     * Internal function for object mapping
     *
     * @param pfUser $oUser
     * @return Memberinfo
     */
    private function _convertUserToMemberInfo( $oUser)
    {
        $oRet = new Memberinfo();

        $oRet->country             = utf8_encode( $oUser->aFields['country']->sValue);
        $oRet->dislikes            = pfUtils::pfUTF8Encode( $oUser->aFields['dislikelist']->sValue);
        $oRet->emailAddress        = utf8_encode( $oUser->aFields['email']->sValue);
        $oRet->enneagramtype1      = utf8_encode( $oUser->aFields['primena']->sValue);
        $oRet->enneagramtype2      = utf8_encode( $oUser->aFields['secena']->sValue);
        $oRet->fullname            = utf8_encode( $oUser->aFields['fullname']->sValue);
        $oRet->gpsCoordinates      = utf8_encode( $oUser->aFields['latitude']->sValue." ".$oUser->aFields['longitude']->sValue);
        $oRet->likes               = pfUtils::pfUTF8Encode( $oUser->aFields['likelist']->sValue);
        $oRet->motto1              = utf8_encode( $oUser->aFields['motto']->sValue);
        $oRet->motto2              = utf8_encode( $oUser->aFields['secmotto']->sValue);
        $oRet->registrationTime    = utf8_encode( $oUser->aFields['registration']->sValue);
        $oRet->town                = utf8_encode( $oUser->aFields['city']->sValue);
        $oRet->tttTestTime         = utf8_encode( $oUser->aFields['ttt_testtime']->sValue);
        $oRet->tttType             = utf8_encode( $oUser->aFields['ttt']->sValue);
        $oRet->username            = utf8_encode( $oUser->aFields['login']->sValue);

        return $oRet;

    }

    /**
     * Gets MemberInfo as specified in req.spec. page 14
     *
     * @param string $sSessionID
     * @param string $sLogin
     * @return Memberinfo
     */
    public function getMemberInfo( $sSessionID, $sLogin)
    {
        $oSession = $oSession = $this->_getSession( $sSessionID);

        $oUser = & pfUtils::pfNew( 'pfUser');
        $oUser->SetRequestingUserID( $oSession->sUsrId);

        // search for ID
        $aResult = pfDB::getDB()->fetchRow( "select id from pfusers where login = '$sLogin'");

        // TODO

        if( $oUser->Load( $aResult['id'])) {
            // ok we found it, assign the values
            $oRet = $this->_convertUserToMemberInfo( $oUser);
        }
        else
            $oRet = new Memberinfo();

        return $oRet;
    }

    /**
     * Computes the differences between axes
     *
     * @param array $aResult
     * @param char $cChar1
     * @param char $cChar2
     * @return array
     */
    private function _computeAxis( $aResult, $cChar1, $cChar2)
    {
        if( !isset( $aResult[$cChar1]))
            $aResult[$cChar1] = 0;
        if( !isset( $aResult[$cChar2]))
            $aResult[$cChar2] = 0;

        if( $aResult[$cChar1] + $aResult[$cChar2] < 5)
            throw new Exception( "Not enough data for Dimension $cChar1/$cChar2");

        if( $aResult[$cChar1] >= $aResult[$cChar2]) {
            $aResult[$cChar1] -= $aResult[$cChar2];
            $aResult[$cChar2] = 0;
        }
        elseif( $aResult[$cChar2] >= $aResult[$cChar1]) {
            $aResult[$cChar2] -= $aResult[$cChar1];
            $aResult[$cChar1] = 0;
        }

        return $aResult;
    }

    /**
     * TakeTTT as specified in req.spec. page 14
     *
     * @param string $sSessionID
     * @param string $sAnswers
     * @return string
     */
    public function TakeTTT( $sSessionID, $sAnswers)
    {
        $oSession = $this->_getSession( $sSessionID);

        $oUser = pfUtils::pfNew( 'pfUser');
        if( !$oUser->Load( $oSession->sUsrId))
            throw new Exception( 'User not found!');

        $sResult = $sLongResult = "";
        $aResult = array();

        $aAnswers = str_split( str_replace( ' ', '', $sAnswers), 1);

        // compute answers
        foreach( $aAnswers as $sChar)
            @$aResult[$sChar]++;

        $aResult = $this->_computeAxis( $aResult, 'e', 'i');
        $aResult = $this->_computeAxis( $aResult, 's', 'n');
        $aResult = $this->_computeAxis( $aResult, 't', 'f');
        $aResult = $this->_computeAxis( $aResult, 'j', 'p');

        // IE
        if( $aResult['i'] >= $aResult['e']) {
            $sLongResult .= 'i+'.$aResult['i'];
            $sResult .= 'i';
        }
        else {
            $sLongResult .= 'e+'.$aResult['e'];
            $sResult .= 'e';
        }

        // SN
        if( $aResult['s'] >= $aResult['n']) {
            $sLongResult .= 's+'.$aResult['s'];
            $sResult .= 's';
        }
        else {
            $sLongResult .= 'n+'.$aResult['n'];
            $sResult .= 'n';
        }

        // TF
        if( $aResult['t'] >= $aResult['f']) {
            $sLongResult .= 't+'.$aResult['t'];
            $sResult .= 't';
        }
        else {
            $sLongResult .= 'f+'.$aResult['f'];
            $sResult .= 'f';
        }

        // JP
        if( $aResult['j'] >= $aResult['p']) {
            $sLongResult .= 'j+'.$aResult['j'];
            $sResult .= 'j';
        }
        else {
            $sLongResult .= 'p+'.$aResult['p'];
            $sResult .= 'p';
        }

        $aFields = array(   'ttt_answers'   => $sAnswers,
                            'ttt_full'      => $sLongResult,
                            'ttt'           => $sResult,
                            'ttt_testtime'  => date( 'Y-m-d H:i:s', time()),
                        );

        $oUser->assign( $aFields);
        $oUser->Save();

        return $sResult;
    }

    /**
     * Execute Search as specified in req.spec. page 15
     *
     * @param string $sSessionID
     * @param boolean $blNoContact
     * @param unknown_type $blNoRCDSent
     * @param unknown_type $blNewlyRegistered
     * @param unknown_type $blInMyCountry
     * @param unknown_type $iMaxKMAway
     * @param unknown_type $aTTTTypes
     * @param unknown_type $blMyPrimEna
     * @param unknown_type $blMySecEnam
     * @param unknown_type $blRelatedEna
     * @param unknown_type $sMottoContains
     * @param unknown_type $iMinLikesShared
     * @param unknown_type $iMinDislikesShared
     * @param unknown_type $iMaxLikesDisliked
     * @param unknown_type $iMaxDislikesLiked
     */
    public function searchForMembers(  $sSessionID, $blNoContact, $blNoRCDSent, $blNewlyRegistered, $blInMyCountry,
                            $iMaxKMAway, $aTTTTypes, $blMyPrimEna, $blMySecEnam, $blRelatedEna, $sMottoContains,
                            $iMinLikesShared, $iMinDislikesShared, $iMaxLikesDisliked, $iMaxDislikesLiked)
    {
        $aRet = array();

        $oSession = $this->_getSession( $sSessionID);

        // build search params
        $aSearch = array(
                            'no_contacts'           => $blNoContact,
                            'no_rcd'                => $blNoRCDSent,
                            'since_logout'          => $blNewlyRegistered,
                            'mycountry'             => $blInMyCountry,
                            'around_kilometers'     => $iMaxKMAway,
                            'match_ttt'             => $aTTTTypes,
                            'same_enna'             => $blMyPrimEna,
                            'onesame_enna'          => $blMySecEnam,
                            'related_enna'          => $blRelatedEna,
                            'motto_contains'        => $sMottoContains,
                            'share_likes'           => $iMinLikesShared,
                            'share_dislikes'        => $iMinDislikesShared,
                            'dislike_likes'         => $iMaxLikesDisliked,
                            'like_nodislikes'       => $iMaxDislikesLiked,
                        );

        // EXPLAIN TODO: we fix this for 100 to make sure nobody kills the server with a soap call
        // fix limited to 100 results
        $oRet = pfQuery::getInstance()->Query( $aSearch, $oSession->sUsrId, 0, 100);

        if( count( $oRet->aRows)) {
            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);
            foreach( $aRows as $oUser) {
                $oMemberinfo = $this->_convertUserToMemberInfo( $oUser);
                $aRet[] = $oMemberinfo;
            }
        }

        return $aRet;
    }

    /**
     * getMemberlist as specified in req.spec. page 15
     *
     * @param string $sSessionID
     * @param string $sUserName
     * @param string $sRCDStatus
     * @return array
     */
    public function getMemberList( $sSessionID, $sUserName, $sRCDStatus)
    {   $aRet = array();

        $oSession = $this->_getSession( $sSessionID);
        $oUser = & pfUtils::pfNew( 'pfUser');
        if( !$oUser->Load( $oSession->sUsrId)) {
            throw new Exception( 'User not found!');
        }

        if( $sUserName != $oUser->aFields['login']->sValue)
            throw new Exception( 'Username mismatch with logged in user');

        // EXPLAIN TODO: we fix this for 100 to make sure nobody kills the server with a soap call
        // fix limited to 100 results
        switch( $sRCDStatus) {
            case 'RCD':
                $aSearch = array('only_rcd'=>1);
                break;
            case 'ACC':
                $aSearch = array('only_acc'=>1);
                break;
            case null:
                $aSearch = array('no_contacts'=>1);
                break;
            default:
                throw new Exception( 'unkown RCD status');
        }
        $oRet = pfQuery::getInstance()->Query( $aSearch, $oSession->sUsrId, 0, 100);
        if( count( $oRet->aRows)) {
            $aRows = pfQuery::getInstance()->LoadRows( $oRet->aRows, $oSession->sUsrId);
            foreach( $aRows as $oUser) {
                $oMemberinfo = $this->_convertUserToMemberInfo( $oUser);
                $aRet[] = $oMemberinfo;
            }
        }

        return $aRet;
    }


}