<?php

class pfInput extends Zend_Filter_Input
{
    const PFINPUT_POST      = 1;
    const PFINPUT_GET       = 2;
    const PFINPUT_COOKIE    = 4;
    const PFINPUT_ALL       = 7;

    static $_oInstance = array();

    /**
     * are cookies disabled?
     *
     * @return boolean
     */
    static public function isCookieDisabled()
    {
        return (count($_COOKIE) == 0) ? true : false;
    }

    /**
     * Gives Input Filter with POST and GET values filled
     *
     * factory, singleton
     *
     * @return pfInput
     */
    static public function getInstance( $Type = pfInput::PFINPUT_ALL)
    {
        if( !isset( self::$_oInstance[$Type])) {
            switch( $Type) {
                case pfInput::PFINPUT_ALL:
                    self::$_oInstance[$Type] = new pfInput( $_REQUEST);
                    break;
                case pfInput::PFINPUT_POST:
                    self::$_oInstance[$Type] = new pfInput( $_POST);
                    break;
                case pfInput::PFINPUT_GET:
                    self::$_oInstance[$Type] = new pfInput( $_GET);
                    break;
                case pfInput::PFINPUT_COOKIE:
                    self::$_oInstance[$Type] = new pfInput( $_COOKIE);
                    break;
            }
        }

        return self::$_oInstance[$Type];
    }

    /**
     * checks if all given fields are there
     *
     * @param array $aRequired
     * @return boolean
     */
    public function testRequired( $aRequired)
    {
        foreach( $aRequired as $sReqField)
            if( !@$this->_source[$sReqField])
                return false;

        return true;
    }

    /**
     * returns Source Array
     *
     * @return array
     */
    public function getArray()
    {
        return $this->_source;
    }

    /**
     * compares entries
     *
     * @param string $skey1
     * @param string $skey2
     * @return boolean
     */
    public function testEqual( $skey1, $skey2)
    {
        return $this->_source[$skey1] == $this->_source[$skey2];
    }

    /**
     * Some basic checks agains SQL injections etc. and returns value of POST
     *
     * @param string $key
     * @return string
     */
    public function getValue( $key)
    {
        // TODO: add quoting etc.

        return @$this->_source[$key];
    }

    /**
     * returns all values
     *
     * @return mixed
     */
    public function getValues()
    {
        return @$this->_source;
    }

}
?>