<?php

/**
 * Query Class - all searching is done here
 *
 */
class pfQuery {

    static $_oInstance = null;

    /**
     * singelton
     *
     * @return pfQuery
     */
    static public function getInstance()
    {
        if( !isset( self::$_oInstance))
            self::$_oInstance = new pfQuery( );

        return self::$_oInstance;
    }

    private function __construct()
    {

    }

    /**
     * Execute the search on database
     *
     *
     *
     * [search] => Array
        [no_contacts] => 1
        [no_rcd] => 1
        [since_logout] => 1
        [since_days] => 3
        [since_logoutttt] => 1
        [since_daysttt] => 3
        [mycountry] => 1
        [around_kilometers] => 5
        [match_ttt] => Array
            (
                [0] => isfj
                [1] => infj
            )

        [same_enna] => 1
        [onesame_enna] => 1
        [related_enna] => 1
        [motto_contains] => mottostring
        [share_likes] => 1
        [share_dislikes] => 1
        [dislike_likes] => 1
        [like_nodislikes] => 1

        [only_rcd] => 1
        [only_acc] => 1
     *
     * @param object
     * @param integer $iUserID
     * @param integer $iPage
     * @param integer $iCount
     */
    public function Query( $aSearch, $iUserID, $iPage = 0, $iCount = 0)
    {
        $oDB = pfDB::getDB();

        $oRet = new stdClass();

        $oUser = pfUtils::pfNew( 'pfUser');
        $oUser->Load( $iUserID);

        $blWhere = false;
        $sSQL = "select id from pfusers ";

        // [no_contacts] [no_rcd]
        if( (isset( $aSearch['no_contacts']) && $aSearch['no_contacts']) || ( isset( $aSearch['no_rcd']) && $aSearch['no_rcd'])) {
            $blWhere = true;
            $sSQL .= "where pfusers.id not in ( ";
            $sSQL .= "select linkid from pfrelations where userid = pfusers.id and status != 'ACC' ";
            if( isset( $aSearch['no_rcd']) && $aSearch['no_rcd']) {
                $sSQL .= " and status != 'RCD' ";
            }
            $sSQL .= ") and ";
            $sSQL .= "pfusers.id not in ( ";
            $sSQL .= "select linkid from pfrelations where userid = pfusers.id and status != 'ACC' ";
            if( isset( $aSearch['no_rcd']) && $aSearch['no_rcd']) {
                $sSQL .= " and status != 'RCD' ";
            }
            $sSQL .= ") ";
        }

        // [since_logout]
        if( isset( $aSearch['since_logout']) && $aSearch['since_logout']) {
            // TODO, actually we check login and not logout was is not exactly what was asked for
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto("pfusers.registration > ?", $oUser->aFields['last_login']->sValue);
        }

        // [since_days]
        if( isset( $aSearch['since_days']) && $aSearch['since_days'] && $aSearch['since_days'] != -1) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            $sSQL .= $oDB->quoteInto( "TO_DAYS( NOW()) - TO_DAYS( pfusers.registration) > ? ", $aSearch['since_days']);
        }

        // [since_logoutttt]
        if( isset( $aSearch['since_logoutttt']) && $aSearch['since_logoutttt']) {
            // TODO, actually we check login and not logout was is not exactly what was asked for
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto( "pfusers.ttt_testtime > ? ", $oUser->aFields['last_login']->sValue);
        }

        // [since_daysttt]
        if( isset( $aSearch['since_daysttt']) && $aSearch['since_daysttt'] && $aSearch['since_daysttt'] != -1) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            $sSQL .= $oDB->quoteInto( "TO_DAYS( NOW()) - TO_DAYS( pfusers.ttt_testtime) > ? ", $aSearch['since_daysttt']);
        }

        // [mycountry]
        if( isset( $aSearch['mycountry']) && $aSearch['mycountry']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto( "pfusers.country = ? ", $oUser->aFields['country']->sValue);
        }

        // [around_kilometers]
        if( isset( $aSearch['around_kilometers']) && $aSearch['around_kilometers'] && $aSearch['around_kilometers'] != -1) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            // TODO !!!!
            $sSQL .= "1 ";
        }

        // [match_ttt]
        if( isset( $aSearch['match_ttt']) && count( $aSearch['match_ttt'])) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            $sSQL .= 'ttt in('. pfUtils::CreateSQLList( $aSearch['match_ttt']).') ';
        }

        // [same_enna]
        if( isset( $aSearch['same_enna']) && $aSearch['same_enna']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto( "pfusers.primena = ? ", $oUser->aFields['primena']->sValue);
        }

        // [onesame_enna]
        if( isset( $aSearch['onesame_enna']) && $aSearch['onesame_enna']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto( "( pfusers.primena = ? or pfusers.secena = ? or pfusers.primena = ? or pfusers.secena = ?) ", $oUser->aFields['primena']->sValue, $oUser->aFields['primena']->sValue, $oUser->aFields['secena']->sValue, $oUser->aFields['secena']->sValue);
        }

        // [related_enna]
        if( isset( $aSearch['related_enna']) && $aSearch['related_enna']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

           // TODO
           $sSQL .= '1 ';
        }

        // [motto_contains]
        if( isset( $aSearch['motto_contains']) && $aSearch['motto_contains']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';
            $sSQL .= $oDB->quoteInto( "(pfusers.motto like ? or pfusers.secmotto like ?) ", '%'.$aSearch['motto_contains'].'%');
        }

        // [share_likes]
        if( isset( $aSearch['share_likes']) && $aSearch['share_likes']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

           // TODO
           $sSQL .= '1 ';

           //$sSQL .= " ( select count(*) from pflikes where type = 1 and text in (".pfUtils::CreateSQLList( $oUser->aLikes).") )";
        }

        // [share_dislikes]
        if( isset( $aSearch['share_dislikes']) && $aSearch['share_dislikes']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

           // TODO
           $sSQL .= '1 ';
        }

        // [dislike_likes]
        if( isset( $aSearch['dislike_likes']) && $aSearch['dislike_likes']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

           // TODO
           $sSQL .= '1 ';
        }

        // [like_nodislikes]
        if( isset( $aSearch['like_nodislikes']) && $aSearch['like_nodislikes']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

           // TODO
           $sSQL .= '1 ';
        }

        // [only_rcd]
        if( isset( $aSearch['only_rcd']) && $aSearch['only_rcd']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            $sSQL .=$oDB->quoteInto( "pfusers.id in (select userid from pfrelations where linkid = ? and status = 'RCD') ", $iUserID);
        }

        // [only_acc]
        if( isset( $aSearch['only_acc']) && $aSearch['only_acc']) {
            if( !$blWhere) {
                $blWhere = true;
                $sSQL .= 'where ';
            }
            else
                $sSQL .= 'and ';

            $sSQL .=$oDB->quoteInto( "pfusers.id in (select userid from pfrelations where (linkid = ?) and status = 'ACC') or
                                      pfusers.id in (select linkid from pfrelations where (userid = ?) and status = 'ACC')", $iUserID);
        }

        // remove user itself
        if( !$blWhere) {
            $blWhere = true;
            $sSQL .= 'where ';
        }
        else
            $sSQL .= 'and ';
        $sSQL .= "pfusers.id != $iUserID ";

        // echo( $sSQL);

        $sCountSQL = str_replace( 'select id', 'select count(*)', $sSQL);

        if( $iPage || $iCount)
            $sSQL .= " limit ".$iPage*$iCount.", $iCount";

        $oRet->aRows = $oDB->fetchAll( $sSQL);

        // generate searchlink
        $sGetSearch = "&";
        $blSep = false;
        foreach( $aSearch as $key => $sValue) {
            if( $blSep)
                $sGetSearch .= '&';
            if( is_array( $sValue)) {
                foreach( $sValue as $sSubKey => $sSubValue)
                    $sGetSearch .= 'search['.$key.']['.$sSubKey.']='.urlencode($sSubValue).'&';
            }
            else
                $sGetSearch .= 'search['.$key.']='.urlencode($sValue);
            $blSep = true;
        }
        $oRet->getsearch = $sGetSearch;

        // generate the page navigation
        if( $iCount) {
            $iTotal = $oDB->fetchOne( $sCountSQL);
            if( $iTotal > $iCount) {
                $pageNavigation = new stdClass();
                $pageNavigation->NrOfPages  = round( $iTotal/$iCount + 0.49);;
                $pageNavigation->iCnt       = $iTotal;
                $pageNavigation->actPage    = $iPage + 1;

                if( $iPage > 0)
                    $pageNavigation->previousPage = 'pg='.($iPage-1).$sGetSearch;
                else
                    $pageNavigation->previousPage = null;

                if( $iPage < $pageNavigation->NrOfPages-1)
                    $pageNavigation->nextPage = 'pg='.($iPage+1).$sGetSearch;
                else
                    $pageNavigation->nextPage = null;

                if( $pageNavigation->NrOfPages > 1)
                {   for ($i=1; $i < $pageNavigation->NrOfPages + 1; $i++)
                    {   $page = new stdClass();
                        $page->url = 'pg='.($i-1).$sGetSearch;
                        $page->selected = 0;
                        if( $i == $pageNavigation->actPage)
                            $page->selected = 1;
                        $pageNavigation->changePage[$i] = $page;
                    }

                    // first/last one
                    $pageNavigation->firstpage = 'pg=0'.$sGetSearch;
                    $iLast =  $pageNavigation->NrOfPages - 1;
                    $pageNavigation->lastpage = 'pg='.$iLast.$sGetSearch;
                }

                $oRet->pagenavigation = $pageNavigation;
            }
        }


        return $oRet;
    }

    /**
     * Load full row info for displaying from userid
     *
     * @param array $aIDs
     * @param integer $iRequestingUserID
     * @return array
     */
    public function LoadRows( $aIDs, $iRequestingUserID)
    {
        if( !$aIDs || !count( $aIDs))
            return null;

        $aRows = array();
        foreach( $aIDs as $iId) {
            $oUser = pfUtils::pfNew( 'pfUser');
            $oUser->SetRequestingUserID( $iRequestingUserID);
            $oUser->load( $iId['id']);
            $aRows[] = $oUser;
        }

        return $aRows;
    }

    public function generatePageNavigation( $sClass = "")
    {   global $myConfig;

        // added in case then method is called from another class
        if($sClass === "")
        {
            $sClass = $this->sThisAction;
        }

        // generate the page navigation
        $pageNavigation = new stdClass();
        $pageNavigation->NrOfPages = $this->iCntPages;
        $pageNavigation->iArtCnt   = $this->iAllArtCnt;
        $pageNavigation->actPage   = $this->iActPage + 1;

        $sUrl = $this->generatePageNavigationURL( $sClass );

        if( $this->iActPage > 0)
            $pageNavigation->previousPage = $sUrl."&pgNr=".($this->iActPage-1);
        else
            $pageNavigation->previousPage = null;

        if( $this->iActPage < $pageNavigation->NrOfPages-1)
            $pageNavigation->nextPage = $sUrl.'&pgNr='.($this->iActPage+1);
        else
            $pageNavigation->nextPage = null;

        if( $pageNavigation->NrOfPages > 1)
        {   for ($i=1; $i < $pageNavigation->NrOfPages + 1; $i++)
            {   $page->url = $sUrl.'&pgNr='.($i-1);
                $page->selected = 0;
                if( $i == $pageNavigation->actPage)
                    $page->selected = 1;
                $pageNavigation->changePage[$i] = $page;
            }

            // first/last one
            $pageNavigation->firstpage = $sUrl.'&pgNr=0';
            $iLast =  $pageNavigation->NrOfPages - 1;
            $pageNavigation->lastpage = $sUrl.'&pgNr='.$iLast;
        }

        return $pageNavigation;
    }
}