<?php

require_once( 'application/core/pfBase.php');

/**
 * 'pfusers' table record handler
 *
 */
class pfUser extends pfBase
{
	/**
	 * $sMainTable indicates main record table
	 *
	 * @var string
	 */
	public $sMainTable = 'pfusers';

	/**
	 * A list of what user likes
	 *
	 * @var array
	 */
	public $aLikes = array();

	/**
	 * A list of what user dislikes
	 *
	 * @var unknown_type
	 */
	public $aDislikes = array();


	/**
	 * Human readable Gps data
	 *
	 * @var unknown_type
	 */
	public $sGps = null;

	/**
	 * Required DB fields
	 *
	 * @var array
	 */
	protected $_aRequiredFields = array('login', 'pwdhash', 'fullname', 'email', 'city', 'country', 'motto');

	private $_iRequestingUserID = null;

    /**
	 * Non editable fields
	 *
	 * @var array
	 */
	protected $_aProtectedFields = array('login');

	public function SetRequestingUserID( $sUserID) {   $this->_iRequestingUserID = $sUserID;   }

    /**
     * Load user info by supplied $sLogin and $sPassword. Returns true on success, false otherwise
     *
     * @param string $sLogin
     * @param string $sPassword
     * @return bool
     */
	public function loadByPassword($sLogin, $sPassword)
	{
	    if (!$sLogin || !$sPassword)
	       return false;

	    $oDB = pfDB::getDB();

	    $sQ  = $oDB->quoteInto('select id from `' . $this->sMainTable. '`  where login = ? ', $sLogin);
        $sQ .= $oDB->quoteInto(' and pwdhash = ?', md5($sPassword));

        $oRs = $oDB->query($sQ);
        $aId = $oRs->fetchAll();
        $sUserId = null;
        if (isset($aId[0]['id']))
            $sUserId = $aId[0]['id'];

        if ($sUserId) {
            $this->load($sUserId);
            return true;
        }
        else {
            return false;
        }
	}

	/**
	 * Load user info by supplied $sId, $sLogin and $sPwdHash. Returns true on success, false otherwise
	 *
	 * @param string $sId  User id
	 * @param string $sLogin User login
	 * @param string $sPwdHash User password
	 * @return bool
	 */
	public function loadByPasswordHash($sId, $sLogin, $sPwdHash)
	{
	    if (!$sId || !$sLogin || !$sPwdHash)
	       return false;

	    $oDB = pfDB::getDB();

        $sQ  = $oDB->quoteInto('select id from `' . $this->sMainTable. '` where id = ? ', $sId);
        $sQ .= $oDB->quoteInto(' and login = ?', $sLogin);
        $sQ .= $oDB->quoteInto(' and pwdhash = ?', $sPwdHash);

        $oRs = $oDB->query($sQ);
        $aId = $oRs->fetchAll();
        $sUserId = null;
        if (isset($aId[0]['id']))
            $sUserId = $aId[0]['id'];

        if ($sUserId) {
            $this->load($sUserId);
            return true;
        }
        else {
            return false;
        }
	}

	/**
	 * Initialises special user values
	 *
	 * @param array $aInput
	 * @param boolean $blOverwriteEmpty
	 * @return int
	 */
	public function assign( $aInput, $blOverwriteEmpty = true)
	{
	    $bRes = 0;

	    if (isset($aInput['password1']) || isset($aInput['password1']))
	    {
            if (!$aInput['password1'])
    	        $bRes = 1;
            if ($aInput['password1'] != $aInput['password2'])
                $bRes = 2;
            if ($bRes == 0)
            $aInput['password'] = $aInput['password1'];
	    }

	    if( isset( $aInput['password'])) {
	       $aInput['pwdhash'] = md5( $aInput['password']);
	       unset( $aInput['password']);
	    }

	    //validates email and email domain
	    if (isset($aInput['email']) && !Zend_Filter::isEmail($aInput['email'], true))
                $bRes = 3;

	    //setting a list of what user likes and dislikes from input
	    if (isset($aInput['likelist'])) {
	        $this->aLikes = explode("\n", $aInput['likelist']);
	        foreach ($this->aLikes as $key=>$sLike)
	           if (trim($sLike))
	              $this->aLikes[$key] = trim($sLike);
	           else
	              unset($this->aLikes[$key]);
	    }

	    if (isset($aInput['dislikelist'])) {
	       $this->aDislikes = explode("\n", $aInput['dislikelist']);
	       foreach ($this->aDislikes as $key=>$sLike)
	           if (trim($sLike))
	              $this->aDislikes[$key] = trim($sLike);
	           else
	              unset($this->aDislikes[$key]);
	    }

	    //dealing with GPS coordintes
        if (isset($aInput['gps'])) {
            if (pfUtils::convertCoordinates($aInput['gps'], $dLat, $dLong))
            {
                $aInput['latitude'] = $dLat;
                $aInput['longitude'] = $dLong;
                $this->sGps = $aInput['gps'];
            }
//            else
//                $bRes = 4;
        }


	    $bAssignRes = parent::assign( $aInput, $blOverwriteEmpty);

	    //finally throwing exceptions
	    if ($bRes == 0) {
	      return $bAssignRes;
	    } elseif ($bRes == 1) {
	       throw new Exception('Please enter your password');
	    } elseif ($bRes == 2) {
	       throw new Exception('Passwords missmatch');
	    } elseif ($bRes == 3) {
	       throw new Exception('Email address or email domain is not valid');
	    } else {
	       throw new Exception('Something is missing, ask Tomas.');
	    }
	}

	/**
	 * Additionally to pfBase::load() loads $this->aLikes and $this->aDislikes
	 */
	public function load($sId)
	{
        $bRes = parent::load($sId);

        //like dislikes
        if ($bRes)
        {
            $oDB = pfDB::getDB();
            $sQ = $oDB->quoteInto('select * from pflikes where userid = ?', $sId);
            $aRes = $oDB->fetchAll($sQ);
            foreach ($aRes as $aRow)
            {
                if ($aRow['type'] == '1')
                    $this->aLikes[] = $aRow['text'];
                if ($aRow['type'] == '0')
                    $this->aDislikes[] = $aRow['text'];
            }

            // status
            if( isset( $this->_iRequestingUserID)) {
                $sQ = $oDB->quoteInto("select status from pfrelations where (linkid = ".$sId." and userid = ?) or (linkid = ? and userid = ".$sId.")", $this->_iRequestingUserID);
                $this->status = $oDB->fetchOne( $sQ);

                if( $this->status != 'ACC') {
                    unset( $this->aFields['fullname']);
                    unset( $this->aFields['email']);
                }
            }
        }

        //gps data
        if ($this->aFields['latitude']->sValue && $this->aFields['longitude']->sValue)
        {
            $this->sGps = $this->aFields['latitude']->sValue>0?($this->aFields['latitude']->sValue. " N, "):
                                                                       -$this->aFields['latitude']->sValue . "S, ";
            $this->sGps .= $this->aFields['longitude']->sValue>0?($this->aFields['longitude']->sValue. " E"):
                                                                       -$this->aFields['longitude']->sValue . " W";
        }

        return $bRes;
	}

	/**
	 * Deals with likes/dislikes lists and initiates record saving
	 *
	 */
	public function save()
	{
	    $oDB = pfDB::getDB();

	    //using transactions for data consistency in case of crash
//	    $oDB->query('transaction start');
        if ($this->sId)
        {
            $sQ  = $oDB->quoteInto('delete from pflikes where userid = ?', $this->sId);
            $oDB->query($sQ);
        }

        $iRet = parent::save();

        //saving what he likes to separate table
        foreach ($this->aLikes as $sLike) {
        	$oDB->insert('pflikes', array( 'userid'  => $this->sId,
        	                               'type'    => '1',
        	                               'text'    => $sLike));
        }
        //saving what he dislike to separate table
        foreach ($this->aDislikes as $sDislike) {
        	$oDB->insert('pflikes', array('userid' => $this->sId,
        	                               'type'  => '0',
        	                               'text'  => $sDislike));
        }

        //commiting transaction after a few updates
//        $oDB->query('commit');

        return $iRet;

	}

	/**
	 * Validates user fields and inserts the record on success
	 *
	 */
    protected function _insert()
    {
        $oDB = pfDB::getDB();
        $sQ = $oDB->quoteInto('select id from ' . $this->sMainTable . ' where login = ? ', $this->aFields['login']->sValue );
        $aRes = $oDB->fetchRow($sQ);
        if ($aRes)
        {
            $this->aFields['login']->setValue('');
            throw new Exception('Login exists, please choose a new one.');
        }

        return parent::_insert();
    }

    public function ChangeStatus( $iLinkUser, $sStatus)
    {
        $oDB = pfDB::getDB();

        $sSQL = $oDB->quoteInto("select id from pfrelations where (linkid = ". (INT)$this->sId ." and userid = ?) or (linkid = ? and userid = ".(INT)$this->sId.")", $iLinkUser);
        $iRowID = $oDB->fetchOne( $sSQL);

        $oRelation = pfUtils::pfNew( 'pfBase');
        $oRelation->Init( 'pfrelations');
        if( $iRowID) {
            $oRelation->Load( $iRowID);
        }

        $oRelation->assign( array(  'userid'    => (INT)$this->sId,
                                    'linkid'    => $iLinkUser,
                                    'status'    => $sStatus,
                                    'lastchange'=> date( 'Y-m-d H:i:s', time())
                                 )
                           );

        $oRelation->save();
    }
}