<?php

require_once('Zend/Session.php');

/**
 * Class containgin various methods expected to be called from any place.
 * Therefore we implemt this class as Singleton
 *
 */
class pfUtils
{

    /**
     * TTT Types
     *
     * @var array
     */
    static protected $_aTTTTypes = array(
                            'istj',
                            'isfj',
                            'infj',
                            'intj',
                            'istp',
                            'isfp',
                            'infp',
                            'intp',
                            'estp',
                            'esfp',
                            'enfp',
                            'entp',
                            'estj',
                            'esfj',
                            'enfj',
                            'entj',
                            );

    /**
     * returns the TTT Types
     *
     * @return array
     */
    static public function getTTTTypes()
    {
        return self::$_aTTTTypes;
    }

	/**
	 * Returns the instance of $sClass class. We use single method in case we need to extend it with modules in future.
	 * In that case we would return the instance of particular module class extending $sClass, but this is not implemented yet :)
	 *
	 * @param string $sClass
	 * @return object
	 */
   	static public function pfNew($sClass)
   	{
   	    //checking for available modules
   	    $oConfig = Zend::registry('config');
   	    if (isset($oConfig->modules))
   	    {
   	        //checking for appropriate module:
   	        $aModules = $oConfig->modules->asArray();
   	        if (isset($aModules[$sClass]))
   	        {
   	            $sModuleClass = $aModules[$sClass];
   	            $sFilename = 'application/modules/' . $sModuleClass . '.php';
   	            //yes we have module for $sClass
   	            if (file_exists($sFilename))
   	                require_once($sFilename);

   	            if (class_exists($sModuleClass))
   	                return new $sModuleClass;
   	        }
   	    }


   	    //no modules - so just create an instance of standard class
   		return new $sClass;
   	}


   	/**
   	 * Returns the correct URI path to the project. Needed if you dont have a own vhost
   	 *
   	 * @return string
   	 */
   	static public function getRewriteBase()
   	{
        $sBase = '';
        if (empty($_SERVER['PATH_INFO'])) {
            $sBase = $_SERVER['REQUEST_URI'];
        } else if ($iPos = strpos($_SERVER['REQUEST_URI'], $_SERVER['PATH_INFO'])) {
            $sBase = substr($_SERVER['REQUEST_URI'], 0, $iPos);
        }
        return rtrim($sBase, '/');
   	}

   	/**
   	 * Savely UTF8 Encodes everything, even if this is an array
   	 *
   	 * @param string or array $In
   	 * @return string or array
   	 */
   	static public function pfUTF8Encode( $In)
   	{
   	    if( is_array( $In)) {
            foreach( $In as $key => $sValue) {
                // recursiv
                if( is_array( $sValue))
                    $In[$key] = pfUtils::pfUTF8Encode( $sValue);
                else
                    $In[$key] = utf8_encode( $sValue);
            }
   	    }
   	    else
   	        $In = utf8_encode( $In);

   	    return $In;
   	}

   	/**
   	 * Savely UTF8 Decodes everything, even if this is an array
   	 *
   	 * @param string or array $In
   	 * @return string or array
   	 */
   	static public function pfUTF8Decode( $In)
   	{
   	    if( is_array( $In)) {
            foreach( $In as $key => $sValue) {
                // recursiv
                if( is_array( $sValue))
                    $In[$key] = pfUtils::pfUTF8Encode( $sValue);
                else
                    $In[$key] = utf8_decode( $sValue);
            }
   	    }
   	    else
   	        $In = utf8_decode( $In);

   	    return $In;
   	}


   	/**
   	 * Returns Latitude and Langitude from $sGpsData (eg. 49.45 N, 11.07 E)
   	 * North, East will be represents as possitive values, South, West as negatives
   	 *
   	 * @param string $sGps
   	 * @param double $dLat
   	 * @param double $dLongs
   	 * @return bool
   	 */
   	static public function convertCoordinates($sGps, &$dLat, &$dLong)
   	{
   	    //"\d+[\.\d+]? ?[NnSs] ?,? ?\d+\[.\d+]? ?[EeWw]";
   	    //perfomance
   	    $sPattern = "(^[0-9]+[\.[0-9]+]?) ?([NnSs]) ?,? ?([0-9]+[\.[0-9]+]?) ?([EeWw])";

        $dLat = 0;
        $dLong = 0;

        if (eregi($sPattern, trim($sGps), $aSubP))
        {
            $dLat = $aSubP[1];
            if (strtolower($aSubP[2]) == 's')
                $dLat *= -1;
            $dLong = $aSubP[3];
            if (strtolower($aSubP[4]) == 'w')
                $dLong *= -1;
        }
        else {
            return false;
        }

        return true;
   	}

	/**
	 * Takes Array and creates IN() list for SQL statement
	 *
	 * @return string
	 */
    static public function CreateSQLList( $aArray)
    {	$sRet = "";

    	$blSep = false;
		foreach( $aArray as $sToken)
		{	if( !$sToken)
				continue;
			if( $blSep)
				$sRet .= ",";
			$sRet .= pfDB::getDB()->quoteInto( '?',$sToken);
			$blSep = true;
		}

    	return $sRet;
    }

}