<?php


/**
 * Demo module for pfUser class. Overrides standard pfUSer class and introduces one new demo method
 * in order to load it instead of pfUSer add the following line to config.inc.php:
 * modules.pfUser      = myUser;
 * And this it.
 */
class myUser extends pfUser
{
    /**
     * Demo method.
     * Loads user info by $sLogin, but does not perform passowrd check, instead checks for password 'demo'
     *
     * @param string $sLogin
     * @param string $sPassword
     * @return bool
     */
	public function loadByPassword($sLogin, $sPassword)
    {
        if (!$sLogin || !$sPassword)
	       return false;

        //user password must be demo for this module
        if ($sPassword != 'demo')
            return;

	    $oDB = pfDB::getDB();

	    $sQ  = $oDB->quoteInto('select id from `' . $this->sMainTable. '`  where login = ? ', $sLogin);

	    //do not check password for this module
	    //$sQ .= $oDB->quoteInto(' and pwdhash = ?', md5($sPassword));

        $oRs = $oDB->query($sQ);
        $aId = $oRs->fetchAll();
        $sUserId = null;
        if (isset($aId[0]['id']))
            $sUserId = $aId[0]['id'];

        if ($sUserId) {
            $this->load($sUserId);
            return true;
        }
        else {
            return false;
        }
    }
}


?>
