<?php

define( 'DEBUG_MODE', false);

if( DEBUG_MODE) {
    // debug only - measure script execution time
    list($usec, $sec) = explode(" ",microtime());
    $time_start = ((float)$usec + (float)$sec);
}

//including main Zend Framework files
require_once( 'Zend.php');

/**
 * Enable Auto Loading. This PHP specific method will be automatically called when you try to get the instance of $class.
 * This way we eliminate the need for including the class files.
 *
 * @param string $class
 */
function __autoload( $class)
{
   Zend::loadClass( $class);
}

require_once( 'Smarty/View/Smarty.php');

// allow exceptions
Zend_Controller_Front::getInstance()->throwExceptions( true);

// load config
$oConfig = new Zend_Config_Ini( '../config.ini.php', "settings", false);
Zend::register('config', $oConfig);

// enable Smarty
$aViewData = array();
$aViewData['scriptPath'] = array( $oConfig->smarty->template_dir);
$oSmartyView = new OXID_View_Smarty( $aViewData);
Zend::register('smarty_view', $oSmartyView);

// main error handling
try {
    // let's do some action
    Zend_Controller_Front::run( $oConfig->installpath.'/application/controllers');
}
catch( Exception $e) {
    // TODO:
    if( DEBUG_MODE) {
        echo( $e->getTraceAsString()."<br><br>\n\n");
        die( "Uncaught exception: <br><br>'{$e->getMessage()}'");
    }

    header('Location: ' . $oConfig->baseurl);
    exit();
}

if( DEBUG_MODE) {
    // -------------------------------------
    // debug only
    // output timing
    list($usec, $sec) = explode(" ",microtime());
    $time_end = ((float)$usec + (float)$sec);
    $time = $time_end - $time_start;
    echo( "\n--- Execution time :"."  $time ---");
    if (function_exists('memory_get_usage')) {
        $kb = (int)(memory_get_usage()/1024);
        echo "<br>\nMemory usage :".$kb." kb";
    }
}