<?php


// define( 'DEBUG_MODE', true);

// startup ZF
require_once 'Zend.php';

/**
 * Enable Auto Loading. This PHP specific method will be automatically called when you try to get the instance of $class.
 * This way we eliminate the need for including the class files.
 *
 * @param string $class
 */
function __autoload( $class)
{
   Zend::loadClass( $class);
}

// load config
$oConfig = new Zend_Config_Ini( 'config.ini.php', "settings", false);
Zend::register('config', $oConfig);

// handle requests
$oSOAPServer = new SoapServer( "../wsdl/PbT.wsdl", array('classmap' => array('Memberinfo' => 'Memberinfo')));
$oSOAPServer->addFunction( 'clearDatabase');
$oSOAPServer->addFunction( 'login');
$oSOAPServer->addFunction( 'logout');
$oSOAPServer->addFunction( 'submitMemberInfo');
$oSOAPServer->addFunction( 'getMemberInfo');
$oSOAPServer->addFunction( 'takeTTT');
$oSOAPServer->addFunction( 'searchForMembers');
$oSOAPServer->addFunction( 'getMemberList');
$oSOAPServer->handle();
exit();


function DebugLog( $sMessage)
{

    if( DEBUG_MODE) {
        error_log( $sMessage);
    }
}
// */

// -----------------------------------------------------------
//
// These functions can be called through SOAP WSDL call
// these are just wrappers functionality is in core/pfCore.php
//
// -----------------------------------------------------------

function clearDatabase()
{
    try {
        return pfCore::getInstance()->clearDatabase();
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}

function login( $sUserName, $sPassword)
{
    try {
        return pfCore::getInstance()->login( pfUtils::pfUTF8Decode( $sUserName), pfUtils::pfUTF8Decode( $sPassword));
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}

function logout( $sSessionID)
{
    try {
        pfCore::getInstance()->logout( $sSessionID);
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}

function submitMemberInfo( $sSessionID, $sUserName, $sPassword, $sFullname, $sEMail, $sCity, $sCountry, $sMotto1, $sMotto2, $aLikes, $aDislikes, $sGPS, $iEnna1, $iEnna2)
{
    try {
        // according to customer answer GPS is a string based like this longitude lattitude, decimal sign is a "."
        // anyway we check this
        $sGPS = str_replace( ',', '.', pfUtils::pfUTF8Decode( $sGPS));
        $aGPS = explode( ' ', trim( $sGPS));
        if( !isset( $aGPS) || count( $aGPS) != 2)
            return;

        // map fields to fit our structure
        $aFields = array(
                            'login'         => pfUtils::pfUTF8Decode( $sUserName),
                            'password'      => pfUtils::pfUTF8Decode( $sPassword),
                            'fullname'      => pfUtils::pfUTF8Decode( $sFullname),
                            'email'         => pfUtils::pfUTF8Decode( $sEMail),
                            'city'          => pfUtils::pfUTF8Decode( $sCity),
                            'country'       => pfUtils::pfUTF8Decode( $sCountry),
                            'motto'         => pfUtils::pfUTF8Decode( $sMotto1),
                            'secmotto'      => pfUtils::pfUTF8Decode( $sMotto2),
                            'latitude'      => $aGPS[0],
                            'longitude'     => $aGPS[1],
                            'primena'       => pfUtils::pfUTF8Decode( $iEnna1),
                            'secena'        => pfUtils::pfUTF8Decode( $iEnna2),
                            'likelist'      => pfUtils::pfUTF8Decode( $aLikes),
                            'dislikelist'   => pfUtils::pfUTF8Decode( $aDislikes),
                        );

        // we do not update username/login
        if( !$sUserName && $sSessionID)
            unset( $aFields['login']);

        return pfCore::getInstance()->submitMemberInfo( $sSessionID, $aFields);
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}

function getMemberInfo( $sSessionID, $sUserName)
{
    try {
        return pfCore::getInstance()->getMemberInfo( $sSessionID, utf8_decode( $sUserName));
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}

function takeTTT( $sSessionID, $sAnswers)
{
    try {
        return utf8_encode( strtoupper( pfCore::getInstance()->TakeTTT( $sSessionID, utf8_decode( $sAnswers))));
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }
}


function searchForMembers(  $sSessionID, $blNoContact, $blNoRCDSent, $blNewlyRegistered, $blInMyCountry,
                            $iMaxKMAway, $aTTTTypes, $blMyPrimEna, $blMySecEnam, $blRelatedEna, $sMottoContains,
                            $iMinLikesShared, $iMinDislikesShared, $iMaxLikesDisliked, $iMaxDislikesLiked)
{

    try {
        return pfCore::getInstance()->searchForMembers( $sSessionID, $blNoContact, $blNoRCDSent, $blNewlyRegistered, $blInMyCountry,
                                                        $iMaxKMAway, $aTTTTypes, $blMyPrimEna, $blMySecEnam, $blRelatedEna, utf8_decode( $sMottoContains),
                                                        $iMinLikesShared, $iMinDislikesShared, $iMaxLikesDisliked, $iMaxDislikesLiked);
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }


}

function getMemberList( $sSessionID, $sUserName, $sRCDStatus)
{
    try {
        $sRCDStatus = strtoupper( utf8_decode( $sRCDStatus));
        switch( $sRCDStatus) {
            case 'IN_CONTACT':
                $sRCDStatus = 'ACC';
                break;
            case 'NO_CONTACT':
                $sRCDStatus = null;
                break;
            case 'RCD':
                break;
            default:
                throw new Exception( 'unkown RCD status');
        }
        return pfCore::getInstance()->getMemberList( $sSessionID, utf8_decode( $sUserName), $sRCDStatus);
    }
    catch (Exception $e) {
        // do nothing
        DebugLog( $e->getMessage());
    }

}