<?php
/**
 * This file conatins the script required to test all tests in this dir.
 * This file is supposed to be executed over PHPUnit framework
 * It is called something like this:
 * phpunit <Test dir>_AllTests
 *
 *
 * LICENSE: This Software is the property of OXID eSales GmbH and is protected
 *          by copyright law - it is NOT Freeware.
 *
 * @copyright   2006 OXID eSales GmbH
 * @version     0.1
 * @since       File available since Version 0.1
 */
require_once 'PHPUnit/Framework/TestSuite.php';
require_once( 'config.inc.php');

/**
 * PHPUnit_Framework_TestCase implemetnation for adding and testing all tests from this dir
 */
class AllTests extends PHPUnit_Framework_TestCase {

    static function suite()
    {
        // update database
        $oConfig = Zend::registry('config');
        $sPasswordCheck = '';
        if ($oConfig->database->password)
            $sPasswordCheck = "-p".$oConfig->database->password;

        $sCommand = "mysql -u".$oConfig->database->username." $sPasswordCheck ".$oConfig->database->dbname." < ../database.sql";
        system( $sCommand);

        $suite = new PHPUnit_Framework_TestSuite('PHPUnit');

        //adding UNIT Tests
        foreach( glob("unit/*Test.php") as $sFilename) {
            require_once( $sFilename);
            $sFilename = 'unit_'.str_replace("/", "_", str_replace( array( ".php", 'unit/'), "", $sFilename));
            $suite->addTestSuite( $sFilename);
        }

        //adding ACCEPTANCE Tests

        foreach( glob("acceptance/*Test.php") as $sFilename) {
            require_once( $sFilename);
            $sFilename = 'acceptance_'.str_replace("/", "_", str_replace( array( ".php", 'acceptance/'), "", $sFilename));
            $suite->addTestSuite( $sFilename);
        }

        return $suite;
    }

}