<?php

require_once 'PHPUnit/Extensions/SeleniumRawTestCase.php';

class Acceptance_IndexPageTest extends PHPUnit_Extensions_SeleniumRawTestCase
{
    public $oConfig;

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');

        $this->setBrowser('*firefox');
        $this->setBrowserUrl( $this->oConfig->baseurl);
    }

    public function testCheckUserRegistrationIsThere()
    {
        $this->open( $this->oConfig->baseurl);
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=Please register here");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("User information"));
		$this->click("link=Home");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->checkForVerificationErrors();
    }

    public function testLogin()
    {
        $this->open( $this->oConfig->baseurl);
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("sLogin", "admin");
		$this->type("sPassword", "gof0r1t");
		$this->click("//input[@value='Login']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("Welcome Lars Jankowfsky"));
		$this->click("link=Status");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=Edit your Details");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("edit[city]", "Nrnberg");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyEquals("Nrnberg", $this->getValue("edit[city]"));
		$this->click("link=Logout");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("User registration"));
    }

    public function testCreateUser()
    {
        $this->open( $this->oConfig->baseurl);
        $this->click("link=Please register here");
        $this->waitForPageToLoad("30000");
        $this->assertEquals("platforms index page", $this->getTitle());
        $this->type("edit[login]", "testuser");
        $this->type("edit[password1]", "123456");
        $this->type("edit[password2]", "123456");
        $this->type("edit[fullname]", "test testmann");
        $this->type("edit[email]", "test@xx.de");
        $this->type("edit[city]", "Freiburg");
        $this->type("edit[country]", "Deutschland");
        $this->type("edit[motto]", "Life sux");
        $this->type("edit[secmotto]", "I am only a test user");
        $this->type("edit[likelist]", "I like mcdon");
        $this->type("edit[likelist]", "I like mcdonalds\ndkfk\nkdfk");
        $this->click("//input[@name='']");
        $this->waitForPageToLoad("30000");
        $this->assertEquals("platforms index page", $this->getTitle());
        $this->verifyTrue($this->isTextPresent("Welcome test testmann"));
    }


}
