<?php

require_once 'PHPUnit/Extensions/SeleniumRawTestCase.php';

class Acceptance_UserPageTest extends PHPUnit_Extensions_SeleniumRawTestCase
{
    public $oConfig;

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');

        $this->setBrowser('*firefox');
        $this->setBrowserUrl( $this->oConfig->baseurl);
    }

    public function testWrongEmailAddress()
    {
        $this->open( $this->oConfig->baseurl);
		$this->click("link=User registration");
		$this->waitForPageToLoad("30000");
		$this->type("edit[login]", "ui");
		$this->type("edit[password1]", "ui");
		$this->type("edit[password2]", "ui");
		$this->type("edit[fullname]", "ui");
		$this->type("edit[email]", "ui");
		$this->type("edit[city]", "ui");
		$this->type("edit[country]", "ui");
		$this->type("edit[motto]", "ui");
		$this->type("edit[secmotto]", "ui");
		$this->type("edit[likelist]", "ui");
		$this->type("edit[dislikelist]", "ui");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->checkForVerificationErrors();
    }

    public function testCreateUser()
    {
        $this->open( $this->oConfig->baseurl);
        $this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=Please register here");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("edit[login]", "dodger");
		$this->type("edit[password1]", "123456");
		$this->type("edit[password2]", "123456");
		$this->type("edit[fullname]", "Leisure Suite Larry");
		$this->type("edit[email]", "larry@oxid-esales.com");
		$this->type("edit[city]", "Freiburg");
		$this->type("edit[country]", "Grmni");
		$this->type("edit[motto]", "Life is hard but amusing");
		$this->type("edit[secmotto]", "Well more amusing");
		$this->type("edit[likelist]", "sex\ngood sex\nmore sex\nok ok beer\nand\nPHP");
		$this->type("edit[dislikelist]", "nothing\nmore nothing");
		$this->type("edit[gps]", "52.538361 N,13.424263 W");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 1 of 40", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("Welcome Leisure Suite Larry"));
		$this->type("edit[country]", "Deutschland");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyEquals("Deutschland", $this->getValue("edit[country]"));
    }

    public function testLogout()
    {
        $this->open( $this->oConfig->baseurl);
        $this->assertEquals("platforms index page", $this->getTitle());
		$this->type("sLogin", "dodger");
		$this->type("sPassword", "123456");
		$this->click("//input[@value='Login']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("Welcome Leisure Suite Larry"));
		$this->click("link=Logout");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("User registration"));
    }

    public function testRegisterWrongData()
    {
        $this->open( $this->oConfig->baseurl);
        $this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=Please register here");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("edit[login]", "dodger");
		$this->type("edit[password1]", "123456");
		$this->type("edit[password2]", "123456");
		$this->type("edit[fullname]", "dkjsfh");
		$this->type("edit[email]", "jhghg");
		$this->type("edit[city]", "ghf");
		$this->type("edit[country]", "ghfgh");
		$this->type("edit[motto]", "fgh");
		$this->type("edit[secmotto]", "fgf");
		$this->type("edit[likelist]", "ghf");
		$this->type("edit[dislikelist]", "hgf");
		$this->type("edit[gps]", "ghf");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("Email address or email domain is not valid"));
		$this->click("//input[@name='']");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("edit[password1]", "123456");
		$this->verifyTrue($this->isTextPresent("Please enter your password"));
		$this->type("edit[password2]", "123456");
		$this->click("//input[@name='']");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->verifyTrue($this->isTextPresent("Login exists, please choose a new one."));
		$this->type("edit[login]", "dodgeris");
		$this->type("edit[password1]", "xxx");
		$this->type("edit[password2]", "xxx");
		$this->type("edit[gps]", "777");
		$this->click("//input[@name='']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
    }

    public function testTTTStart()
    {
        $this->open( $this->oConfig->baseurl);
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("sLogin", "dodger");
		$this->type("sPassword", "123456");
		$this->click("//input[@value='Login']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=TTT");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 1 of 40", $this->getTitle());
		$this->click("answer");
		$this->click("next");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 2 of 40", $this->getTitle());
		$this->click("link=2");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 2 of 40", $this->getTitle());
		$this->click("document.forms[0].answer[1]");
		$this->click("next");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 3 of 40", $this->getTitle());
		$this->click("link=3");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 3 of 40", $this->getTitle());
		$this->click("answer");
		$this->click("next");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 4 of 40", $this->getTitle());
		$this->click("back");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 3 of 40", $this->getTitle());
		$this->verifyEquals("on", $this->getValue("answer"));
		$this->click("link=29");
		$this->assertEquals("platforms TTT Question 29 of 40", $this->getTitle());
		$this->click("document.forms[0].answer[1]");
		$this->click("next");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 30 of 40", $this->getTitle());
		$this->click("link=40");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 40 of 40", $this->getTitle());
		$this->click("document.forms[0].answer[1]");
		$this->click("back");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 39 of 40", $this->getTitle());
		$this->click("link=Logout");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("sLogin", "admin");
		$this->type("sPassword", "gof0r1t");
		$this->click("//input[@value='Login']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=TTT");
		$this->assertEquals("platforms TTT Question 1 of 40", $this->getTitle());
		$this->click("link=Logout");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->type("sLogin", "dodger");
		$this->type("sPassword", "123456");
		$this->click("//input[@value='Login']");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms index page", $this->getTitle());
		$this->click("link=TTT");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 1 of 40", $this->getTitle());
		$this->click("link=29");
		$this->waitForPageToLoad("30000");
		$this->assertEquals("platforms TTT Question 29 of 40", $this->getTitle());
		$this->verifyEquals("on", $this->getValue("document.forms[0].answer[1]"));
    }
}
