<?php

require_once 'PHPUnit/Framework/TestCase.php';
require_once( 'config.inc.php');

class Unit_pfGenericTest extends PHPUnit_Framework_TestCase
{
    public $oConfig;

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');
    }

    public function testCreateDemoUsers()
    {
        // create test entries into user table
        pfDB::getDB()->query( 'delete from pfusers where id > 99');

        $iUserCnt = 1000;

        $aGeneratedIDs = array();
        $aStatus = array( 'RCD', 'ACC', 'DEC');
        $iRelID = $iLikesID = 100;
        $aCountries = array( 'germany', 'austria', 'france', 'usa', 'england');
        $aLikes = array( 'bananas', 'cars', 'php', 'friends', 'sex', 'oxid');

        echo( "generating $iUserCnt test users\n");
        $aTypes = pfUtils::getTTTTypes();

        for( $i=0; $i<$iUserCnt; $i++) {

            $sUser = uniqid('',true);
            $iID = 100+$i;
            $aGeneratedIDs[] = $iID;

            $aUser = array(
                                'ID'            =>  $iID,
                                'LOGIN'         =>  $sUser,
                                'PWDHASH'       =>  md5( $sUser),
                                'FULLNAME'      =>  'heinz '.$sUser,
                                'EMAIL'         =>  $sUser.'@yahoo.com',
                                'CITY'          =>  $sUser.'city',
                                'COUNTRY'       =>  $aCountries[rand( 0, count( $aCountries)-1)],
                                'MOTTO'         =>  'PHP rulez',
                                'SECMOTTO'      =>  'test string',
                                'LATITUDE'      =>  rand( 48000, 49100)/1000,
                                'LONGITUDE'     =>  rand( 9000, 11000)/1000,
                                'PRIMENA'       =>  rand( 1, 9),
                                'SECENA'        =>  rand( 0, 9),
                                'REGISTRATION'  =>  date( "Y-m-d H:i:s", rand( 1136070000, 1169792317)),
                                'TTT'           =>  $aTypes[rand( 0, count( $aTypes)-1)],
                                'TTT_TESTTIME'  =>  date( "Y-m-d H:i:s", rand( 1136070000, 1169792317)),
                                'LAST_LOGIN'    =>  date( "Y-m-d H:i:s", rand( 1136070000, 1169792317)),
                          );

            pfDB::getDB()->insert( 'pfusers', $aUser);

            // some relations
            for( $j=0; $j<4; $j++) {
                $aRelation = array( 'ID'            => $iRelID++,
                                    'USERID'        => $iID,
                                    'LINKID'        => $aGeneratedIDs[rand( 0, count( $aGeneratedIDs)-1)],
                                    'STATUS'        => $aStatus[rand( 0, count( $aStatus)-1)],
                                    'LASTCHANGE'    => date( "Y-m-d H:i:s", rand( 1136070000, 1169792317)),
                                  );
                pfDB::getDB()->insert( 'pfrelations', $aRelation);
            }

            // some likes
            for( $j=0; $j<4; $j++) {
                $aLikeInsert = array( 'ID'          => $iLikesID++,
                                    'USERID'        => $iID,
                                    'TYPE'          => rand( 0, 1),
                                    'TEXT'          => $aLikes[rand( 0, count( $aLikes)-1)],
                                  );
                pfDB::getDB()->insert( 'pflikes', $aLikeInsert);
            }

        }
    }

    /*public function testIndexPerformance()
    {
        $dRequestsPerSecond = 10;

        $aOutput = array();
        echo( "benchmarking ".$this->oConfig->baseurl."\n");
        exec( "ab -n100 -c10 ".$this->oConfig->baseurl . "/", $aOutput, $i);
        $sFulltext = implode( "\n", $aOutput);
        $aTmp = explode( "Requests per second:", $sFulltext);
        $dRequests = @floatval($aTmp[1]);
        if( $dRequests < $dRequestsPerSecond) {
            echo( "FAILED! - Performance only #$dRequests / sec.\n");
            if( !$dRequests)
                echo( $sFulltext);
        }
        else
            echo( "Performance #$dRequests / sec.\n");


        $this->assertTrue( $dRequests > $dRequestsPerSecond);
    }*/




}
