<?php

require_once 'PHPUnit/Framework/TestCase.php';
require_once( 'config.inc.php');

class Unit_pfSOAPTest extends PHPUnit_Framework_TestCase
{
    public $oConfig;
    public $oClient = null;

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');
        $this->oClient = new SoapClient( $this->oConfig->baseurl."/wsdl", array( 'trace' => 1, 'location' => $this->oConfig->baseurl."/soap"));
    }

    public function testLoginCorrectData()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");

        $this->assertNotNull( $sSessionID);
    }

    public function testLoginWrongData()
    {
        $sSessionID = $this->oClient->login( "admin","WRONG");

        $this->assertNull( $sSessionID);
    }

    public function testCreateUser()
    {
        $this->oClient->submitMemberInfo( null, 'soaptest', '123456', 'SOAP Test USer', 'soap@oxid-esales.com', utf8_encode('Nrnberg'), 'Deutschland', 'SOAP is cool!', 'Immer noch cool', array('I like bananas', 'and apples', 'and fruits in general'), array( utf8_encode("I don't like l"), utf8_encode("and I dont like y")), "47.926005 7.921829", 5, 3);

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'soaptest'");

        $this->assertEquals( $aRow['email'], 'soap@oxid-esales.com');
    }

    public function testCreateInvalidUser()
    {
        $this->oClient->submitMemberInfo( null, 'soaptest', '123456', 'SOAP Test USer', 'WRONG!', utf8_encode('Nrnberg'), 'Deutschland', 'SOAP is cool!', 'Immer noch cool', array('I like bananas', 'and apples', 'and fruits in general'), array( utf8_encode("I don't like l"), utf8_encode("and I dont like y")), "47.926005 7.921829", 5, 3);

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'soaptest'");

        $this->assertEquals( $aRow['email'], 'soap@oxid-esales.com');
    }

    public function testUpdateUserWithUserName()
    {
        $sSessionID = $this->oClient->login("soaptest","123456");
        $this->assertNotNull( $sSessionID);

        $this->oClient->submitMemberInfo( $sSessionID, 'soaptest', '123456', 'SOAP Test USer', 'soap_correct@oxid-esales.com', utf8_encode('Nrnberg'), 'Deutschland', 'SOAP is cool!', 'Immer noch cool', array('I like bananas', 'and apples', 'and fruits in general'), array( utf8_encode("I don't like l"), utf8_encode("and I dont like y")), "47.926005 7.921829", 5, 3);

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'soaptest'");

        $this->assertEquals( $aRow['email'], 'soap@oxid-esales.com');
    }

    public function testUpdateUser()
    {
        $sSessionID = $this->oClient->login("soaptest","123456");
        $this->assertNotNull( $sSessionID);

        $this->oClient->submitMemberInfo( $sSessionID, null, '123456', 'SOAP Test USer', 'soap_correct@oxid-esales.com', utf8_encode('Nrnberg'), 'Deutschland', 'SOAP is cool!', 'Immer noch cool', array('I like bananas', 'and apples', 'and fruits in general'), array( utf8_encode("I don't like l"), utf8_encode("and I dont like y")), "47.926005 7.921829", 5, 3);

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'soaptest'");

        $this->assertEquals( $aRow['email'], 'soap_correct@oxid-esales.com');
    }

    public function testKillSession()
    {
        $sSessionID = $this->oClient->login("soaptest","123456");
        $this->assertNotNull( $sSessionID);

        $this->oClient->logout( $sSessionID);

        $this->oClient->submitMemberInfo( $sSessionID, 'soaptest', '123456', 'SOAP Test USer', 'soap_wrong@oxid-esales.com', utf8_encode('Nrnberg'), 'Deutschland', 'SOAP is cool!', 'Immer noch cool', array('I like bananas', 'and apples', 'and fruits in general'), array( utf8_encode("I don't like l"), utf8_encode("and I dont like y")), "47.926005 7.921829", 5, 3);

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'soaptest'");

        $this->assertEquals( $aRow['email'], 'soap_correct@oxid-esales.com');
    }

    public function testGetMemberInfo()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");
        $this->assertNotNull( $sSessionID);

        $oRet = $this->oClient->getMemberInfo( $sSessionID, 'test');

        $this->assertEquals( $oRet->fullname, "");
        $this->assertEquals( $oRet->username, 'test');
    }

    public function testTakeTTT()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");
        $this->assertNotNull( $sSessionID);

        $sTTT = $this->oClient->TakeTTT( $sSessionID, 'spnfjiteitepefnfejpefjijffjsnfifnispjssn');

        $this->assertEquals( $sTTT, 'ISFJ');

        $aRow = pfDB::getDB()->fetchRow("select * from pfusers where login = 'admin'");

        $this->assertEquals( $aRow['ttt_full'], 'i+0s+0f+6j+2');
    }

    public function testQueryForMembers()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");
        $this->assertNotNull( $sSessionID);

        $aRet = $this->oClient->searchForMembers( $sSessionID, 1, null, null, null, null, null, null, null, null, null, null, null, null, null);

        $this->assertEquals( $aRet[0]->town, 'Freiburg');
    }

    /*
    // commmented as i sux when db is empty after test...
    public function testClearDatabase()
    {
        // security problem here - no session - why ?
        $this->oClient->clearDatabase();

        $iCnt = pfDB::getDB()->fetchOne("select count(*) from pfusers");
        $this->assertEquals( $iCnt, 0);
    }*/

    public function testgetMemberListRCD()
    {
        $sSessionID = $this->oClient->login("test","123456");
        $this->assertNotNull( $sSessionID);

        $aRet = $this->oClient->getMemberList( $sSessionID, "test", "RCD");
        @$this->assertEquals( $aRet[0]->username, 'admin');
    }

    public function testgetMemberListACC()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");
        $this->assertNotNull( $sSessionID);

        $aRet = $this->oClient->getMemberList( $sSessionID, "admin", "in_contact");
        @$this->assertEquals( $aRet[0]->fullname, 'Nachbar Testuser');
    }

    public function testgetMemberListNOCONTACT()
    {
        $sSessionID = $this->oClient->login("admin","gof0r1t");
        $this->assertNotNull( $sSessionID);

        $aRet = $this->oClient->getMemberList( $sSessionID, "admin", "no_contact");
        //@$this->assertEquals( $aRet[0]->fullname, 'Nachbar Testuser');

        //print_r( $aRet);
    }

}
