<?php


/**
 * Tests for pfUser as well as all pfBase logics
 *
 */
class Unit_pfUserTest extends PHPUnit_Framework_TestCase
{
    public $oConfig;

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');
    }


    /**
     * Testing object Loading
     *
     */
    public function testLoad()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        try {
            $bRes = $oUser->load(1);
        }
        catch (Exception $e)
        {
            $this->assertTrue(false);
        }

        $this->assertTrue(true);

        $this->assertEquals($oUser->sId, 1);
        $this->assertEquals($oUser->aFields['id']->sHtmlValue, '1');
    }

    /**
     * Testing object Loading
     *
     */
    public function testAssign()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        $aInput = array('fullname' => 'Test User2',
                        'password' => 'test',
                        'login' => 'test2');
        try
        {
            $oUser->assign($aInput);
        }
        catch (Exception $eError)
        {
            $this->assertEquals($eError->getMessage(), 'Email address or email domain is not valid');
        }

        $aInput = array('fullname' => 'Test User2',
                        'login' => 'test2',
                        'email' => 'tom@bom.com',
                        'password1' => 'test',
                        'password2' => 'test');

        $oUser->assign($aInput);

        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Test User2');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Test User2');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser->aFields['login']->sValue, 'test2');
    }


    /**
     * Testing object Doubleassignments
     *
     */
    public function testDoubleAssign()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        $aInput = array('fullname' => 'Test User2',
                        'login' => 'test2',
                        'email' => 'tom@bom.com',
                        'password1' => 'test',
                        'password2' => 'test');
        $oUser->assign($aInput);

        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Test User2');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Test User2');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, 'test2');

        $aInput = array('fullname' => 'Test User3',
                        'email' => 'tom@bom.com',
                        'password1' => 'test',
                        'password2' => 'test');
        $oUser->assign($aInput, false);

        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Test User3');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Test User3');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, 'test2');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');

        $aInput = array('fullname' => 'Test User4',
                        'email' => 'tom@bom.com',
                        'password1' => 'test',
                        'password2' => 'test');
        $oUser->assign($aInput, true);

        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Test User4');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Test User4');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, '');

    }

    /**
     * Testing special chars assignement
     *
     */
    public function testHtmlSpecialChars()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        $aInput = array('fullname' => 'Special chars \' " <> \\ &&',
                        'login' => 'test',
                        'email' => 'tom@bom.com',
                        'password1' => 'test',
                        'password2' => 'test');
        $oUser->assign($aInput);

        $aInput2 = array('login' => 'test2 \' <> ',
                         'email' => 'tom@bom.com',
                         'password1' => 'test',
                         'password2' => 'test');
        $oUser->assign($aInput2, false);

        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Special chars \' " <> \\ &&');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Special chars &#039; &quot; &lt;&gt; \\ &amp;&amp;');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser->aFields['login']->sValue, 'test2 \' <> ');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, 'test2 &#039; &lt;&gt; ');
    }

    /**
     * Testing object Insert
     *
     */
    public function testInsert()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        $aInput = array('fullname' => 'Inserted User',
                        'password' => 'test',
                        'login' => 'inserted login',
                        'email' => 'tom@bom.com',
                        'city'  => 'Freiburg',
                        'country' => 'de',
                        'motto' => 'PHP rulez',
                        'secmotto' => 'PHP still rulez',
                        'latitude'  => 49.45,
                        'longitude'  => 11.07,
                        'primena'  => '4',
                        'secena'  => 8);

        $oUser->assign($aInput);
        $sId = $oUser->save();

        $this->assertTrue( $sId !== false);

        $oUser2 = & pfUtils::pfNew('pfUser');
        $oUser2->Load($sId);
        $this->assertEquals($oUser2->aFields['email']->sValue, 'tom@bom.com');
        $this->assertEquals($oUser2->aFields['city']->sValue, 'Freiburg');
        $this->assertEquals($oUser2->aFields['country']->sValue, 'de');
        $this->assertEquals($oUser2->aFields['motto']->sValue, 'PHP rulez');
        $this->assertEquals($oUser2->aFields['secmotto']->sValue, 'PHP still rulez');
        $this->assertEquals($oUser2->aFields['latitude']->sValue, '49.45');
        $this->assertEquals($oUser2->aFields['longitude']->sValue, '11.07');
        $this->assertEquals($oUser2->aFields['primena']->sValue, '4');
        $this->assertEquals($oUser2->aFields['secena']->sValue, '8');

    }

    /**
     * Testing object Update
     *
     */
   public function testUpdate()
    {
        $oUserDetect = & pfUtils::pfNew('pfUser');
        $blRes = $oUserDetect->loadByPassword('inserted login', 'test');
        $sId = $oUserDetect->sId;

        $oUser = & pfUtils::pfNew('pfUser');
        $oUser->load( $sId);
        $oUser->aFields['fullname']->setValue('New name');
        $oUser->aFields['login']->setValue('New login "');
        $oUser->Save();

        $aInput = array('email' => 'tom@bom.com',
                        'city'  => 'Freiburg',
                        'country' => 'de',
                        'motto' => 'PHP rulez',
                        'secmotto' => 'PHP still rulez',
                        'latitude'  => '49.45',
                        'longitude'  => '11.07',
                        'primena'  => '4',
                        'secena'  => 8);

        $oUser->assign($aInput, false);
        $sId = $oUser->save();

        $oUser2 = & pfUtils::pfNew('pfUser');
        $oUser2->load( $sId);

        $this->assertEquals($oUser2->sId, $sId);
        $this->assertEquals($oUser2->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser2->aFields['fullname']->sValue, 'New name');
        $this->assertEquals($oUser2->aFields['fullname']->sHtmlValue, 'New name');
        $this->assertEquals($oUser2->aFields['login']->sValue, 'inserted login');
        $this->assertEquals($oUser2->aFields['login']->sHtmlValue, 'inserted login');
        $this->assertEquals($oUser2->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser2->aFields['id']->sHtmlValue, $sId);
        $this->assertEquals($oUser2->aFields['email']->sValue, 'tom@bom.com');
        $this->assertEquals($oUser2->aFields['city']->sValue, 'Freiburg');
        $this->assertEquals($oUser2->aFields['country']->sValue, 'de');
        $this->assertEquals($oUser2->aFields['motto']->sValue, 'PHP rulez');
        $this->assertEquals($oUser2->aFields['secmotto']->sValue, 'PHP still rulez');
        $this->assertEquals($oUser2->aFields['latitude']->sValue, '49.45');
        $this->assertEquals($oUser2->aFields['longitude']->sValue, '11.07');
        $this->assertEquals($oUser2->aFields['primena']->sValue, '4');
        $this->assertEquals($oUser2->aFields['secena']->sValue, '8');

        //updating back
        $oUser2->load( $sId);
        $oUser2->aFields['fullname']->setValue('Inserted User');
        $oUser2->aFields['login']->setValue('inserted login2');
        $oUser2->Save();

    }
    /**
     * Testing object Login
     *
     */
    public function testLogin()
    {
        $oUser = & pfUtils::pfNew('pfUser');
        $blRes = $oUser->loadByPassword('name2', 'test2');
        $this->assertTrue(!$blRes);
        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, '');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['id']->sHtmlValue, '');

        $blRes = $oUser->loadByPassword('inserted login2', 'test');
        $this->assertFalse($blRes);
        // removed because update protect value are not allowed
//        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
//        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Inserted User');
//        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Inserted User');
//        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
//        $this->assertEquals($oUser->aFields['login']->sHtmlValue, 'inserted login2');
    }

    /**
     * Testing object Session Login
     *
     */
    public function testSessionLogin()
    {
        $oUserDetect = & pfUtils::pfNew('pfUser');
        $blRes = $oUserDetect->loadByPassword('inserted login', 'test');
        $sId = $oUserDetect->sId;

        $oUser = & pfUtils::pfNew('pfUser');
        $blRes = $oUser->loadByPassword($sId, 'name', 'test2');
        $this->assertTrue(!$blRes);
        $this->assertEquals($oUser->sId, null);
        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, '');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, '');
        $this->assertEquals($oUser->aFields['id']->sHtmlValue, '');

        $blRes = $oUser->loadByPasswordHash($sId, 'inserted login', '098f6bcd4621d373cade4e832627b4f6');

        $this->assertTrue($blRes);
        $this->assertEquals($oUser->sId, $sId);
        $this->assertEquals($oUser->aFields['fullname']->sName, 'fullname');
        $this->assertEquals($oUser->aFields['fullname']->sValue, 'Inserted User');
        $this->assertEquals($oUser->aFields['fullname']->sHtmlValue, 'Inserted User');
        $this->assertEquals($oUser->aFields['pwdhash']->sHtmlValue, '098f6bcd4621d373cade4e832627b4f6');
        $this->assertEquals($oUser->aFields['login']->sHtmlValue, 'inserted login');
        $this->assertEquals($oUser->aFields['id']->sHtmlValue, $sId);
    }

    /**
     * Testing delete
     *
     */
    public function testDelete()
    {
        $oUserDetect = & pfUtils::pfNew('pfUser');
        $blRes = $oUserDetect->loadByPassword('inserted login', 'test');
        $sId = $oUserDetect->sId;
        $oUser = & pfUtils::pfNew('pfUser');
        $blRet1 = $oUser->load($sId);
        $this->assertTrue($blRet1);
        $oUser->delete();
        $bRet2 = $oUser->load($sId);
        $this->assertFalse($bRet2);
    }

}
