<?php


/**
 * Tests for pfUser as well as all pfBase logics
 *
 */
class Unit_pfUtilsTest extends PHPUnit_Framework_TestCase
{
    public $oConfig;

    /**
     * Returns Latitude from coordinates or false on failure
     *
     * @param string $sGps
     * @return double
     */
    private function getLatitude($sGps)
    {
        if (pfUtils::convertCoordinates($sGps, $dLat, $dLong))
            return $dLat;
        else
            return false;
    }


    /**
     * Returns longitude from GPS coordinates or false on failure
     *
     * @param string $sGps
     * @return double
     */
    private function getLongitude($sGps)
    {
        if (pfUtils::convertCoordinates($sGps, $dLat, $dLong))
            return $dLong;
        else
            return false;
    }

    protected function setUp()
    {
        $this->oConfig = Zend::registry('config');
    }

    /**
     * Testing getLatitude()
     *
     */
    public function testGetLatitude()
    {
        $this->assertEquals($this->getLatitude('49.45 N, 11.07 W'), 49.45);
        $this->assertEquals($this->getLatitude('49.45N 11.07E'), 49.45);
        $this->assertEquals($this->getLatitude('49.45 S, 11.07 w'), -49.45);
        $this->assertEquals($this->getLatitude('15.45 s11.07 e'), -15.45);
        $this->assertEquals($this->getLatitude('56.45 n,11E'), 56.45);
        $this->assertEquals($this->getLatitude('49.45S11.07E'), -49.45);
        $this->assertEquals($this->getLatitude('49S11w'), -49);
        $this->assertEquals($this->getLatitude('15.45 s11.07 e'), -15.45);
        $this->assertEquals($this->getLatitude('56.45n11E'), 56.45);
        //$this->assertEquals($this->getLongitude('4n11e'), 4);
    }

    /**
     * Testing getLatitude()
     *
     */
    public function testGetLongitude()
    {
        $this->assertEquals($this->getLongitude('49.45 N, 11.07 W'), -11.07);
        $this->assertEquals($this->getLongitude('49.45N 11.07E'), 11.07);
        $this->assertEquals($this->getLongitude('49.45 S, 11.07 w'), -11.07);
        $this->assertEquals($this->getLongitude('15.45 s11 e'), 11);
        $this->assertEquals($this->getLongitude('56.45 n,11w'), -11);
        $this->assertEquals($this->getLongitude('49.45S11.07E'), 11.07);
        $this->assertEquals($this->getLongitude('49S11w'), -11);
        $this->assertEquals($this->getLongitude('15.45 s11.07 e'), 11.07);
        $this->assertEquals($this->getLongitude('56.45n11E'), 11);
        //$this->assertEquals($this->getLongitude('4n1e'), 1);
        $this->assertEquals($this->getLongitude('40n ,11.0e'), 11);

    }
}